/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.fluids;

import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BloodHelper {
    public static ItemStack getBloodContainerInHotbar(InventoryPlayer inventory) {
        int hotbarSize = InventoryPlayer.func_70451_h();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (ItemStackUtil.isEmpty(stack) || !BloodHelper.canStoreBlood(stack)) continue;
            return stack;
        }
        return ItemStackUtil.getEmptyStack();
    }

    public static boolean canStoreBlood(@Nonnull ItemStack stack) {
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return ((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(new FluidStack(ModFluids.blood, 1000), false) > 0;
        }
        return false;
    }

    public static ItemStack getGlassBottleInHotbar(InventoryPlayer inventory) {
        int hotbarSize = InventoryPlayer.func_70451_h();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (ItemStackUtil.isEmpty(itemStack) || !itemStack.func_77973_b().equals(Items.field_151069_bo)) continue;
            return itemStack;
        }
        return ItemStackUtil.getEmptyStack();
    }

    public static int getBlood(@Nonnull ItemStack stack) {
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            IFluidHandler cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            return BloodHelper.getBlood(cap);
        }
        return 0;
    }

    public static int getBlood(@Nonnull IFluidHandler cap) {
        int l = 0;
        for (IFluidTankProperties p : cap.getTankProperties()) {
            FluidStack s = p.getContents();
            if (s == null || !ModFluids.blood.equals(s.getFluid())) continue;
            l += s.amount;
        }
        return l;
    }

    public static int drain(@Nonnull ItemStack stack, int amount, boolean doDrain, boolean exact) {
        if (exact && doDrain && BloodHelper.drain(stack, amount, false, false) != amount) {
            return 0;
        }
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            FluidStack fluidStack = ((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).drain(amount, doDrain);
            return fluidStack == null ? 0 : fluidStack.amount;
        }
        return 0;
    }

    public static int fill(@Nonnull ItemStack stack, int amount, boolean doFill) {
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return ((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).fill(new FluidStack(ModFluids.blood, amount), doFill);
        }
        return 0;
    }

    public static int fillBloodIntoInventory(EntityPlayer player, int amt) {
        int filled;
        if (amt <= 0) {
            return 0;
        }
        ItemStack stack = BloodHelper.getBloodContainerInHotbar(player.field_71071_by);
        if (!ItemStackUtil.isEmpty(stack) && (filled = BloodHelper.fill(stack, amt, true)) > 0) {
            if (filled < amt) {
                return BloodHelper.fillBloodIntoInventory(player, amt - filled);
            }
            return 0;
        }
        ItemStack glas = BloodHelper.getGlassBottleInHotbar(player.field_71071_by);
        if (!ItemStackUtil.isEmpty(glas) && Configs.autoConvertGlasBottles) {
            ItemStack bloodBottle = new ItemStack((Item)ModItems.bloodBottle, 1, 0);
            int filled2 = BloodHelper.fill(bloodBottle, amt, true);
            if (filled2 == 0) {
                VampirismMod.log.w("BloodHelper", "Failed to fill blood bottle with blood", new Object[0]);
            }
            ItemStackUtil.decr(glas);
            if (ItemStackUtil.isEmpty(glas)) {
                player.field_71071_by.func_184437_d(glas);
            }
            if (!player.field_71071_by.func_70441_a(bloodBottle)) {
                player.func_71019_a(bloodBottle, false);
            }
            return BloodHelper.fillBloodIntoInventory(player, amt - filled2);
        }
        return amt;
    }
}

