/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class ItemBloodBottle
extends VampirismItem {
    public static final int AMOUNT = 9;
    private static final String name = "blood_bottle";
    private static final int MULTIPLIER = 100;
    private static final int capacity = 900;

    public ItemBloodBottle() {
        super(name);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        IBlockState b = world.func_180495_p(pos);
        return b.func_177230_c().hasTileEntity(b) && world.func_175625_s(pos).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 15;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack(itemIn, 1));
        subItems.add(new ItemStack(itemIn, 1, 9));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new BloodBottleFluidHandler(stack, 900);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        VampirePlayer vampire = VampirePlayer.get(playerIn);
        if (vampire.getLevel() == 0) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (vampire.getBloodStats().needsBlood()) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (!(player instanceof EntityPlayer)) {
            player.func_184597_cx();
            return;
        }
        int blood = BloodHelper.getBlood(stack);
        VampirePlayer vampire = VampirePlayer.get((EntityPlayer)player);
        if (vampire.getLevel() == 0 || blood == 0 || !vampire.getBloodStats().needsBlood()) {
            player.func_184597_cx();
            return;
        }
        if (blood > 0 && count == 1) {
            EnumHand activeHand = player.func_184600_cs();
            int drink = Math.min(blood, 300);
            if (BloodHelper.drain(stack, drink, true, true) > 0) {
                vampire.getBloodStats().addBlood(Math.round((float)drink / 100.0f), 0.3f);
            }
            player.func_184611_a(activeHand, stack);
            blood = BloodHelper.getBlood(stack);
            if (blood > 0) {
                player.func_184598_c(player.func_184600_cs());
            }
        }
    }
}

