/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.Multimap;
import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemObsidianArmor
extends VampirismHunterArmor
implements IItemWithTier {
    private static final String baseRegName = "obsidian_armor";
    private final int[] DAMAGE_REDUCTION_ULTIMATE = new int[]{4, 7, 9, 4};
    private final int[] DAMAGE_REDUCTION_ENHANCED = new int[]{3, 7, 8, 3};
    private final int[] DAMAGE_REDUCTION_NORMAL = new int[]{3, 6, 7, 3};
    private final float[] SPEED_REDUCTION = new float[]{-0.025f, -0.1f, -0.05f, -0.025f};

    public static boolean isFullyEquipped(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!ItemStackUtil.isEmpty(stack) && stack.func_77973_b() instanceof ItemObsidianArmor) continue;
            return false;
        }
        return true;
    }

    public ItemObsidianArmor(EntityEquipmentSlot equipmentSlotIn) {
        super(ItemArmor.ArmorMaterial.IRON, equipmentSlotIn, baseRegName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        IItemWithTier.TIER t = this.getTier(stack);
        if (t != IItemWithTier.TIER.NORMAL) {
            tooltip.add(TextFormatting.AQUA + UtilLib.translate("text.vampirism.item_tier." + t.name().toLowerCase()));
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        switch (this.getTier(stack)) {
            case ENHANCED: {
                return this.getTextureLocation("obsidian_armor_of_hell_enhanced", slot, type);
            }
            case ULTIMATE: {
                return this.getTextureLocation("obsidian_armor_of_hell_ultimate", slot, type);
            }
        }
        return this.getTextureLocation("obsidian_armor_of_hell", slot, type);
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> map = super.getAttributeModifiers(slot, stack);
        if (slot == this.field_77881_a) {
            map.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[slot.func_188454_b()], "Speed modifier", (double)this.getSpeedReduction(slot.func_188454_b(), stack), 2));
        }
        return map;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
            subItems.add(this.setTier(new ItemStack(itemIn), t));
        }
    }

    @Override
    public IItemWithTier.TIER getTier(ItemStack stack) {
        NBTTagCompound tag = UtilLib.checkNBT(stack);
        if (tag.func_74764_b("tier")) {
            try {
                return IItemWithTier.TIER.valueOf(tag.func_74779_i("tier"));
            }
            catch (IllegalArgumentException e) {
                VampirismMod.log.e("ObsidianArmor", e, "Unknown item tier %s", tag.func_74779_i("tier"));
            }
        }
        return IItemWithTier.TIER.NORMAL;
    }

    @Override
    public ItemStack setTier(ItemStack stack, IItemWithTier.TIER tier) {
        NBTTagCompound tag = UtilLib.checkNBT(stack);
        tag.func_74778_a("tier", tier.name());
        return stack;
    }

    @Override
    protected int getDamageReduction(int slot, ItemStack stack) {
        IItemWithTier.TIER tier = this.getTier(stack);
        switch (tier) {
            case ULTIMATE: {
                return this.DAMAGE_REDUCTION_ULTIMATE[slot];
            }
            case ENHANCED: {
                return this.DAMAGE_REDUCTION_ENHANCED[slot];
            }
        }
        return this.DAMAGE_REDUCTION_NORMAL[slot];
    }

    private float getSpeedReduction(int slot, ItemStack stack) {
        return this.SPEED_REDUCTION[slot];
    }
}

