/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VampirismHunterArmor
extends ItemArmor
implements ISpecialArmor {
    protected static final UUID[] VAMPIRISM_ARMOR_MODIFIER = new UUID[]{UUID.fromString("f0b9a417-0cec-4629-8623-053cd0feec3c"), UUID.fromString("e54474a9-62a0-48ee-baaf-7efddca3d711"), UUID.fromString("ac0c33f4-ebbf-44fe-9be3-a729f7633329"), UUID.fromString("8839e157-d576-4cff-bf34-0a788131fe0f")};
    private final String registeredName;

    public VampirismHunterArmor(ItemArmor.ArmorMaterial materialIn, EntityEquipmentSlot equipmentSlotIn, String baseRegName) {
        super(materialIn, 0, equipmentSlotIn);
        this.func_77637_a(VampirismMod.creativeTab);
        String regName = baseRegName + "_" + equipmentSlotIn.func_188450_d();
        this.setRegistryName("vampirism", regName);
        this.func_77655_b("vampirism." + baseRegName + "." + equipmentSlotIn.func_188450_d());
        this.registeredName = regName;
    }

    public String getRegisteredName() {
        return this.registeredName;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        if (Helper.isVampire((Entity)playerIn)) {
            tooltip.add(TextFormatting.RED + UtilLib.translate("text.vampirism.poisonous_to_vampires"));
        }
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        stack.func_77972_a(damage, entity);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.getDamageReduction(slot, armor);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        if (slot == this.field_77881_a) {
            map.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[slot.func_188454_b()], "Armor modifier", (double)this.getDamageReduction(slot.func_188454_b(), stack), 0));
            map.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[slot.func_188454_b()], "Armor toughness", this.getToughness(slot.func_188454_b(), stack), 0));
        }
        return map;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, (double)this.getDamageReduction(slot, armor) / 25.0, Integer.MAX_VALUE);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (player.field_70173_aa % 16 == 8 && Helper.isVampire((Entity)player)) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 20, 1));
        }
    }

    protected abstract int getDamageReduction(int var1, ItemStack var2);

    protected String getTextureLocation(String name, EntityEquipmentSlot slot, String type) {
        return String.format("vampirism:textures/models/armor/%s_layer_%d%s.png", name, slot == EntityEquipmentSlot.LEGS ? 2 : 1, type == null ? "" : "_overlay");
    }

    protected double getToughness(int slot, ItemStack stack) {
        return this.field_189415_e;
    }
}

