/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.DefaultSkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillPlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import net.minecraft.util.ResourceLocation;

public abstract class VampirismSkill<T extends ISkillPlayer>
extends DefaultSkill<T> {
    private String description = null;

    @Override
    public ResourceLocation getIconLoc() {
        return null;
    }

    @Override
    public String getLocalizedDescription() {
        return this.description == null ? null : UtilLib.translate(this.description);
    }

    @Override
    public String getUnlocalizedName() {
        return "text.vampirism.skill." + this.getID();
    }

    public void setHasDefaultDescription() {
        this.description = "text.vampirism.skill." + this.getID() + ".desc";
    }

    public static class SimpleVampireSkill
    extends VampirismSkill<IVampirePlayer> {
        private final String id;
        private final int u;
        private final int v;

        public SimpleVampireSkill(String id, int u, int v, boolean desc) {
            this.id = id;
            this.u = u;
            this.v = v;
            if (desc) {
                this.setHasDefaultDescription();
            }
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public int getMinU() {
            return this.u;
        }

        @Override
        public int getMinV() {
            return this.v;
        }
    }

    public static class SimpleHunterSkill
    extends VampirismSkill<IHunterPlayer> {
        private final String id;
        private final int u;
        private final int v;

        public SimpleHunterSkill(String id, int u, int v, boolean desc) {
            this.id = id;
            this.u = u;
            this.v = v;
            if (desc) {
                this.setHasDefaultDescription();
            }
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public int getMinU() {
            return this.u;
        }

        @Override
        public int getMinV() {
            return this.v;
        }
    }
}

