/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.potion.blood;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.util.ItemStackUtil;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.items.IBloodPotionCategory;
import de.teamlapen.vampirism.api.items.IBloodPotionEffect;
import de.teamlapen.vampirism.api.items.IBloodPotionPropertyRandomizer;
import de.teamlapen.vampirism.api.items.IBloodPotionRegistry;
import de.teamlapen.vampirism.potion.blood.BloodPotionCategory;
import de.teamlapen.vampirism.potion.blood.BloodPotionEffect;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.WeightedRandom;

public class BloodPotionRegistry
implements IBloodPotionRegistry {
    private final List<BloodPotionCategory> categoriesGood = Lists.newArrayList();
    private final List<BloodPotionCategory> categoriesBad = Lists.newArrayList();
    private final Map<String, IBloodPotionEffect> allEffects = Maps.newHashMap();

    @Override
    @Nullable
    public IBloodPotionEffect getEffectFromId(@Nonnull String id) {
        return this.allEffects.get(id);
    }

    @Override
    @Nonnull
    public List<String> getLocCategoryDescForItem(@Nonnull ItemStack item) {
        LinkedList categories = Lists.newLinkedList();
        categories.addAll(this.categoriesBad);
        categories.addAll(this.categoriesGood);
        ArrayList desc = Lists.newArrayList();
        for (IBloodPotionCategory category : categories) {
            if (!category.containsItem(item)) continue;
            desc.add(UtilLib.translate(category.getUnlocDescription()));
        }
        return desc;
    }

    @Override
    public IBloodPotionCategory getOrCreateCategory(@Nonnull String id, boolean isBad, String unlocDesc) {
        List<BloodPotionCategory> categories = isBad ? this.categoriesBad : this.categoriesGood;
        for (BloodPotionCategory category : categories) {
            if (!category.getId().equals(id)) continue;
            return category;
        }
        BloodPotionCategory category = new BloodPotionCategory(id, unlocDesc);
        categories.add(category);
        return category;
    }

    @Override
    @Nonnull
    public IBloodPotionEffect getRandomEffect(@Nullable ItemStack item, boolean bad, Random rnd) {
        ArrayList effects = Lists.newArrayList();
        List<BloodPotionCategory> categories = bad ? this.categoriesBad : this.categoriesGood;
        for (BloodPotionCategory category : categories) {
            if (!ItemStackUtil.isEmpty(item) && category.containsItem(item)) {
                for (IBloodPotionRegistry.WeightedEffect effect : category.getEffectsCopy()) {
                    effect.field_76292_a *= 5;
                    effects.add(effect);
                }
                continue;
            }
            effects.addAll(category.getEffectsCopy());
        }
        return ((IBloodPotionRegistry.WeightedEffect)WeightedRandom.func_76271_a((Random)rnd, (List)effects)).effect;
    }

    @Override
    public IBloodPotionEffect registerPotionEffect(String id, IBloodPotionCategory category, boolean isBad, Potion potion, int weight, IBloodPotionPropertyRandomizer randomizer) {
        if (this.allEffects.containsKey(id)) {
            throw new IllegalArgumentException("Blood Potion Effect with id " + id + " is already registered: " + this.allEffects.get(id));
        }
        if (!this.categoriesGood.contains(category) && !this.categoriesBad.contains(category)) {
            throw new IllegalArgumentException("Category " + category + " is not registered");
        }
        BloodPotionEffect effect = new BloodPotionEffect(id, potion, isBad, weight, randomizer);
        this.allEffects.put(id, effect);
        ((BloodPotionCategory)category).addEffect(effect, weight);
        return effect;
    }
}

