/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.lib.util.SimpleSpawnerLogic;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.entity.hunter.EntityBasicHunter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTent
extends TileEntity
implements ITickable {
    private SimpleSpawnerLogic spawnerLogic = new SimpleSpawnerLogic(){

        @Override
        public BlockPos getSpawnerPosition() {
            return TileTent.this.func_174877_v();
        }

        @Override
        public World getSpawnerWorld() {
            return TileTent.this.field_145850_b;
        }

        @Override
        protected void onReset() {
        }

        @Override
        protected void onSpawned(Entity e) {
            super.onSpawned(e);
            if (e instanceof EntityBasicHunter) {
                ((EntityBasicHunter)e).makeCampHunter(this.getSpawningBox());
            }
        }
    };
    private boolean spawn = false;

    public TileTent() {
        this.spawnerLogic.setEntityName("vampirism.vampireHunter");
        this.spawnerLogic.setActivateRange(64);
        this.spawnerLogic.setSpawnRange(6);
        this.spawnerLogic.setMinSpawnDelay(600);
        this.spawnerLogic.setMaxSpawnDelay(1000);
        this.spawnerLogic.setMaxNearbyEntities(2);
        this.spawnerLogic.setLimitTotalEntities(VReference.HUNTER_CREATURE_TYPE);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(1.0, 0.0, 1.0);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return null;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean hasFastRenderer() {
        return super.hasFastRenderer();
    }

    public boolean isSpawner() {
        return this.spawn;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.spawnerLogic.readFromNbt(nbt);
        this.spawn = nbt.func_74767_n("spawn");
    }

    public boolean func_145842_c(int id, int type) {
        return this.spawnerLogic.setDelayToMin(id) || super.func_145842_c(id, type);
    }

    public void setSpawn(boolean spawn) {
        this.spawn = spawn;
    }

    public void func_73660_a() {
        if (this.spawn) {
            this.spawnerLogic.updateSpawner();
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt = super.func_189515_b(compound);
        this.spawnerLogic.writeToNbt(nbt);
        nbt.func_74757_a("spawn", this.spawn);
        return nbt;
    }
}

