/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.bow;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.render.IModelRegister;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemLivingwoodBow
extends ItemBow
implements IManaUsingItem,
IModelRegister {
    private static final Predicate<ItemStack> AMMO_FUNC = s -> s != null && s.func_77973_b() instanceof ItemArrow;
    public static final int MANA_PER_DAMAGE = 40;

    public ItemLivingwoodBow() {
        this("livingwoodBow");
    }

    public ItemLivingwoodBow(String name) {
        this.func_77637_a(BotaniaCreativeTab.INSTANCE);
        GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)new ResourceLocation("Botania", name));
        this.func_77655_b(name);
        this.func_77656_e(500);
        this.func_185043_a(new ResourceLocation("minecraft:pull"), (stack, worldIn, entityIn) -> {
            if (entityIn == null) {
                return 0.0f;
            }
            ItemStack itemstack = entityIn.func_184607_cu();
            return itemstack != null && itemstack.func_77973_b() instanceof ItemLivingwoodBow ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) * this.chargeVelocityMultiplier() / 20.0f : 0.0f;
        });
    }

    @Nonnull
    public String func_77657_g(@Nonnull ItemStack par1ItemStack) {
        return super.func_77657_g(par1ItemStack).replaceAll("item.", "item.botania:");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, @Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        boolean flag = this.canFire(stack, player);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !flag) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, EntityLivingBase shooter, int useTicks) {
        EntityPlayer player = (EntityPlayer)shooter;
        boolean flag = this.canFire(stack, player);
        ItemStack itemstack = this.getAmmo(player);
        int i = (int)((float)(this.func_77626_a(stack) - useTicks) * this.chargeVelocityMultiplier());
        if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)player, (int)i, (itemstack != null || flag ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (itemstack != null || flag) {
            float f;
            if (itemstack == null) {
                itemstack = new ItemStack(Items.field_151032_g);
            }
            if ((double)(f = ItemLivingwoodBow.func_185059_b((int)i)) >= 0.1) {
                boolean infinite;
                boolean bl = infinite = player.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemArrow && ((ItemArrow)itemstack.func_77973_b()).isInfinite(itemstack, stack, player);
                if (!world.field_72995_K) {
                    int k;
                    int j;
                    ItemArrow itemarrow = (ItemArrow)(itemstack.func_77973_b() instanceof ItemArrow ? itemstack.func_77973_b() : Items.field_151032_g);
                    EntityArrow entityarrow = itemarrow.func_185052_a(world, itemstack, shooter);
                    entityarrow.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    if (f == 1.0f) {
                        entityarrow.func_70243_d(true);
                    }
                    if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                        entityarrow.func_70240_a(k);
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                        entityarrow.func_70015_d(100);
                    }
                    if (infinite) {
                        entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
                    world.func_72838_d((Entity)entityarrow);
                    this.onFire(stack, shooter, infinite, entityarrow);
                }
                world.func_184148_a(null, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }

    float chargeVelocityMultiplier() {
        return 1.0f;
    }

    boolean canFire(ItemStack stack, EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0 || PlayerHelper.hasAmmo(player, AMMO_FUNC);
    }

    void onFire(ItemStack bow, EntityLivingBase living, boolean infinity, EntityArrow arrow) {
        if (living instanceof EntityPlayerMP) {
            ToolCommons.damageItem(bow, 1, living, 40);
            if (((EntityPlayerMP)living).field_71134_c.func_73081_b().func_77144_e() && !infinity) {
                PlayerHelper.consumeAmmo((EntityPlayer)((EntityPlayerMP)living), AMMO_FUNC);
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (!world.field_72995_K && player instanceof EntityPlayer && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool(stack, (EntityPlayer)player, 80, true)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 3 || super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    private ItemStack getAmmo(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

