/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import gnu.trove.list.array.TIntArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemDice
extends ItemRelic {
    private static final int[] SIDES_FOR_MOON_PHASES = new int[]{-1, 0, 1, 2, -1, 2, 3, 4};
    public static ItemStack[] relicStacks;

    public ItemDice() {
        super("dice");
        relicStacks = new ItemStack[]{new ItemStack(ModItems.infiniteFruit), new ItemStack(ModItems.kingKey), new ItemStack(ModItems.flugelEye), new ItemStack(ModItems.thorRing), new ItemStack(ModItems.odinRing), new ItemStack(ModItems.lokiRing)};
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (this.isRightPlayer(player, stack) && !player.field_70170_p.field_72995_K) {
            int moonPhase = world.field_73011_w.func_76559_b(world.func_72820_D());
            int relic = SIDES_FOR_MOON_PHASES[moonPhase];
            if (this.hasRelicAlready(player, relic)) {
                TIntArrayList possible = new TIntArrayList();
                TIntArrayList alreadyHas = new TIntArrayList();
                for (int i = 0; i < 6; ++i) {
                    if (this.hasRelicAlready(player, i)) {
                        alreadyHas.add(i);
                        continue;
                    }
                    possible.add(i);
                }
                if (alreadyHas.size() > 0) {
                    possible.add(alreadyHas.get(world.field_73012_v.nextInt(alreadyHas.size())));
                }
                relic = possible.get(world.field_73012_v.nextInt(possible.size()));
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            if (this.hasRelicAlready(player, relic)) {
                player.func_145747_a(new TextComponentTranslation("botaniamisc.dudDiceRoll", new Object[]{relic + 1}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN)));
                --stack.field_77994_a;
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            player.func_145747_a(new TextComponentTranslation("botaniamisc.diceRoll", new Object[]{relic + 1}).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN)));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)relicStacks[relic].func_77946_l());
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    public boolean shouldDamageWrongPlayer() {
        return false;
    }

    private boolean hasRelicAlready(EntityPlayer player, int relic) {
        if (relic < 0 || relic > 5 || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        EntityPlayerMP mpPlayer = (EntityPlayerMP)player;
        Item item = relicStacks[relic].func_77973_b();
        IRelic irelic = (IRelic)item;
        Achievement achievement = irelic.getBindAchievement();
        return mpPlayer.func_147099_x().func_77443_a(achievement);
    }
}

