/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityBabylonWeapon;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemKingKey
extends ItemRelic
implements IManaUsingItem {
    private static final String TAG_WEAPONS_SPAWNED = "weaponsSpawned";
    private static final String TAG_CHARGING = "charging";
    public static final int WEAPON_TYPES = 12;

    public ItemKingKey() {
        super("kingKey");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack par1ItemStack, World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        ItemKingKey.setCharging(par1ItemStack, true);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)par1ItemStack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase living, int time) {
        int spawned = ItemKingKey.getWeaponsSpawned(stack);
        if (spawned == 20) {
            ItemKingKey.setCharging(stack, false);
            ItemKingKey.setWeaponsSpawned(stack, 0);
        }
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        int spawned = ItemKingKey.getWeaponsSpawned(stack);
        if (!(count == this.func_77626_a(stack) || spawned >= 20 || living.field_70170_p.field_72995_K || living instanceof EntityPlayer && !ManaItemHandler.requestManaExact(stack, (EntityPlayer)living, 150, true))) {
            Vector3 look = new Vector3(living.func_70040_Z()).multiply(1.0, 0.0, 1.0);
            double playerRot = Math.toRadians(living.field_70177_z + 90.0f);
            if (look.x == 0.0 && look.z == 0.0) {
                look = new Vector3(Math.cos(playerRot), 0.0, Math.sin(playerRot));
            }
            look = look.normalize().multiply(-2.0);
            int div = spawned / 5;
            int mod = spawned % 5;
            Vector3 pl = look.add(Vector3.fromEntityCenter((Entity)living)).add(0.0, 1.6, (double)div * 0.1);
            Random rand = living.field_70170_p.field_73012_v;
            Vector3 axis = look.normalize().crossProduct(new Vector3(-1.0, 0.0, -1.0)).normalize();
            double rot = (double)mod * Math.PI / 4.0 - 1.5707963267948966;
            Vector3 axis1 = axis.multiply((double)div * 3.5 + 5.0).rotate(rot, look);
            if (axis1.y < 0.0) {
                axis1 = axis1.multiply(1.0, -1.0, 1.0);
            }
            Vector3 end = pl.add(axis1);
            EntityBabylonWeapon weapon = new EntityBabylonWeapon(living.field_70170_p, living);
            weapon.field_70165_t = end.x;
            weapon.field_70163_u = end.y;
            weapon.field_70161_v = end.z;
            weapon.field_70177_z = living.field_70177_z;
            weapon.setVariety(rand.nextInt(12));
            weapon.setDelay(spawned);
            weapon.setRotation(MathHelper.func_76142_g((float)(-living.field_70177_z + 180.0f)));
            living.field_70170_p.func_72838_d((Entity)weapon);
            weapon.func_184185_a(BotaniaSoundEvents.babylonSpawn, 1.0f, 1.0f + living.field_70170_p.field_73012_v.nextFloat() * 3.0f);
            ItemKingKey.setWeaponsSpawned(stack, spawned + 1);
        }
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public static boolean isCharging(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CHARGING, false);
    }

    public static int getWeaponsSpawned(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_WEAPONS_SPAWNED, 0);
    }

    public static void setCharging(ItemStack stack, boolean charging) {
        ItemNBTHelper.setBoolean(stack, TAG_CHARGING, charging);
    }

    public static void setWeaponsSpawned(ItemStack stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_WEAPONS_SPAWNED, count);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }
}

