/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screens.config;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.config.ColorConfig;
import mcp.mobius.waila.config.FormattingConfig;
import mcp.mobius.waila.config.OverlayConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class ScreenFormatConfig
extends GuiScreen {
    public static final String MOD_NAME_FORMAT = "\u00a79\u00a7o%s";
    public static final String BLOCK_FORMAT = "\u00a7r\u00a7f%s";
    public static final String FLUID_FORMAT = "\u00a7r\u00a7f%s";
    public static final String ENTITY_FORMAT = "\u00a7r\u00a7f%s";
    public static final String META_FORMAT = "\u00a77[%s@%d]";
    public static final int BACKGROUND_COLOR = 0x100010;
    public static final int GRADIENT_TOP_COLOR = 0x5000FF;
    public static final int GRADIENT_BOTTOM_COLOR = 2621567;
    public static final int FONT_COLOR = 0xA0A0A0;
    private static final Predicate<String> HEX_COLOR = new Predicate<String>(){

        public boolean apply(@Nullable String input) {
            if (input == null) {
                return false;
            }
            if (input.length() == 1) {
                return input.equalsIgnoreCase("#");
            }
            return input.startsWith("#") && input.substring(1).matches("^[a-zA-Z0-9]*$") && input.length() < 8;
        }
    };
    private final GuiScreen parent;
    private GuiTextField nameFormat;
    private GuiTextField blockFormat;
    private GuiTextField fluidFormat;
    private GuiTextField entityFormat;
    private GuiTextField metaFormat;
    private GuiTextField backgroundColor;
    private GuiTextField gradientTop;
    private GuiTextField gradientBottom;
    private GuiTextField textColor;

    public ScreenFormatConfig(GuiScreen parent) {
        this.parent = parent;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 125, this.field_146295_m - 25, 80, 20, I18n.func_74838_a((String)"screen.button.ok")));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 40, this.field_146295_m - 25, 80, 20, I18n.func_74838_a((String)"screen.button.cancel")));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 + 45, this.field_146295_m - 25, 80, 20, I18n.func_74838_a((String)"screen.button.default")));
        int textFieldOffset = 0;
        if (!ColorConfig.ACTIVE_CONFIGS.isEmpty()) {
            this.field_146292_n.add(new ButtonCycleTheme(this, 3, this.field_146294_l / 2 - 75, this.field_146295_m - 48, 150, 20, ColorConfig.ACTIVE_CONFIGS));
            textFieldOffset = -10;
        }
        this.nameFormat = new GuiTextField(3, this.field_146289_q, this.field_146294_l / 4, 20 + textFieldOffset, 150, 16);
        this.nameFormat.func_146180_a(StringEscapeUtils.escapeJava((String)FormattingConfig.modNameFormat));
        this.blockFormat = new GuiTextField(4, this.field_146289_q, this.field_146294_l / 4, 40 + textFieldOffset, 150, 16);
        this.blockFormat.func_146180_a(StringEscapeUtils.escapeJava((String)FormattingConfig.blockFormat));
        this.fluidFormat = new GuiTextField(5, this.field_146289_q, this.field_146294_l / 4, 60 + textFieldOffset, 150, 16);
        this.fluidFormat.func_146180_a(StringEscapeUtils.escapeJava((String)FormattingConfig.fluidFormat));
        this.entityFormat = new GuiTextField(6, this.field_146289_q, this.field_146294_l / 4, 80 + textFieldOffset, 150, 16);
        this.entityFormat.func_146180_a(StringEscapeUtils.escapeJava((String)FormattingConfig.entityFormat));
        this.metaFormat = new GuiTextField(7, this.field_146289_q, this.field_146294_l / 4, 100 + textFieldOffset, 150, 16);
        this.metaFormat.func_146180_a(StringEscapeUtils.escapeJava((String)FormattingConfig.metaFormat));
        this.backgroundColor = new GuiTextField(8, this.field_146289_q, this.field_146294_l / 4, 120 + textFieldOffset, 150, 16);
        this.backgroundColor.func_146180_a(OverlayConfig.toHex(new Color(OverlayConfig.bgcolor)));
        this.backgroundColor.func_175205_a(HEX_COLOR);
        this.gradientTop = new GuiTextField(9, this.field_146289_q, this.field_146294_l / 4, 140 + textFieldOffset, 150, 16);
        this.gradientTop.func_146180_a(OverlayConfig.toHex(new Color(OverlayConfig.gradient1)));
        this.gradientTop.func_175205_a(HEX_COLOR);
        this.gradientBottom = new GuiTextField(9, this.field_146289_q, this.field_146294_l / 4, 160 + textFieldOffset, 150, 16);
        this.gradientBottom.func_146180_a(OverlayConfig.toHex(new Color(OverlayConfig.gradient2)));
        this.gradientBottom.func_175205_a(HEX_COLOR);
        this.textColor = new GuiTextField(9, this.field_146289_q, this.field_146294_l / 4, 180 + textFieldOffset, 150, 16);
        this.textColor.func_146180_a(OverlayConfig.toHex(new Color(OverlayConfig.fontcolor)));
        this.textColor.func_175205_a(HEX_COLOR);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"choice.format.modname"), this.nameFormat.field_146209_f + this.nameFormat.field_146218_h + 5, this.nameFormat.field_146210_g + 5, 0xFFFFFF);
        this.nameFormat.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"choice.format.blockname"), this.blockFormat.field_146209_f + this.blockFormat.field_146218_h + 5, this.blockFormat.field_146210_g + 5, 0xFFFFFF);
        this.blockFormat.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"choice.format.fluidname"), this.fluidFormat.field_146209_f + this.fluidFormat.field_146218_h + 5, this.fluidFormat.field_146210_g + 5, 0xFFFFFF);
        this.fluidFormat.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"choice.format.entityname"), this.entityFormat.field_146209_f + this.entityFormat.field_146218_h + 5, this.entityFormat.field_146210_g + 5, 0xFFFFFF);
        this.entityFormat.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"choice.format.metadata"), this.metaFormat.field_146209_f + this.metaFormat.field_146218_h + 5, this.metaFormat.field_146210_g + 5, 0xFFFFFF);
        this.metaFormat.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"choice.format.background"), this.backgroundColor.field_146209_f + this.backgroundColor.field_146218_h + 5, this.backgroundColor.field_146210_g + 5, 0xFFFFFF);
        this.backgroundColor.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"choice.format.gradienttop"), this.gradientTop.field_146209_f + this.gradientTop.field_146218_h + 5, this.gradientTop.field_146210_g + 5, 0xFFFFFF);
        this.gradientTop.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"choice.format.gradientbottom"), this.gradientBottom.field_146209_f + this.gradientBottom.field_146218_h + 5, this.gradientBottom.field_146210_g + 5, 0xFFFFFF);
        this.gradientBottom.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_74838_a((String)"choice.format.font"), this.textColor.field_146209_f + this.textColor.field_146218_h + 5, this.textColor.field_146210_g + 5, 0xFFFFFF);
        this.textColor.func_146194_f();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            Minecraft.func_71410_x().func_147108_a(this.parent);
        }
        this.nameFormat.func_146201_a(typedChar, keyCode);
        this.blockFormat.func_146201_a(typedChar, keyCode);
        this.fluidFormat.func_146201_a(typedChar, keyCode);
        this.entityFormat.func_146201_a(typedChar, keyCode);
        this.metaFormat.func_146201_a(typedChar, keyCode);
        this.backgroundColor.func_146201_a(typedChar, keyCode);
        this.gradientTop.func_146201_a(typedChar, keyCode);
        this.gradientBottom.func_146201_a(typedChar, keyCode);
        this.textColor.func_146201_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nameFormat.func_146192_a(mouseX, mouseY, mouseButton);
        this.blockFormat.func_146192_a(mouseX, mouseY, mouseButton);
        this.fluidFormat.func_146192_a(mouseX, mouseY, mouseButton);
        this.entityFormat.func_146192_a(mouseX, mouseY, mouseButton);
        this.metaFormat.func_146192_a(mouseX, mouseY, mouseButton);
        this.backgroundColor.func_146192_a(mouseX, mouseY, mouseButton);
        this.gradientTop.func_146192_a(mouseX, mouseY, mouseButton);
        this.gradientBottom.func_146192_a(mouseX, mouseY, mouseButton);
        this.textColor.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                Minecraft.func_71410_x().func_147108_a(this.parent);
                this.updateConfig();
            }
            case 1: {
                Minecraft.func_71410_x().func_147108_a(this.parent);
            }
            case 2: {
                this.nameFormat.func_146180_a(StringEscapeUtils.escapeJava((String)MOD_NAME_FORMAT));
                this.blockFormat.func_146180_a(StringEscapeUtils.escapeJava((String)"\u00a7r\u00a7f%s"));
                this.fluidFormat.func_146180_a(StringEscapeUtils.escapeJava((String)"\u00a7r\u00a7f%s"));
                this.entityFormat.func_146180_a(StringEscapeUtils.escapeJava((String)"\u00a7r\u00a7f%s"));
                this.metaFormat.func_146180_a(StringEscapeUtils.escapeJava((String)META_FORMAT));
                this.backgroundColor.func_146180_a(OverlayConfig.toHex(new Color(0x100010)));
                this.gradientTop.func_146180_a(OverlayConfig.toHex(new Color(0x5000FF)));
                this.gradientBottom.func_146180_a(OverlayConfig.toHex(new Color(2621567)));
                this.textColor.func_146180_a(OverlayConfig.toHex(new Color(0xA0A0A0)));
            }
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void updateConfig() {
        ConfigHandler config = ConfigHandler.instance();
        config.setConfig("general", "waila.cfg.modnameformat", this.nameFormat.func_146179_b());
        FormattingConfig.modNameFormat = StringEscapeUtils.unescapeJava((String)this.nameFormat.func_146179_b());
        if (this.blockFormat.func_146179_b().contains("%s")) {
            config.setConfig("general", "waila.cfg.blocknameformat", this.blockFormat.func_146179_b());
            FormattingConfig.blockFormat = StringEscapeUtils.unescapeJava((String)this.blockFormat.func_146179_b());
        }
        if (this.fluidFormat.func_146179_b().contains("%s")) {
            config.setConfig("general", "waila.cfg.fluidnameformat", this.fluidFormat.func_146179_b());
            FormattingConfig.fluidFormat = StringEscapeUtils.unescapeJava((String)this.fluidFormat.func_146179_b());
        }
        if (this.entityFormat.func_146179_b().contains("%s")) {
            config.setConfig("general", "waila.cfg.entitynameformat", this.entityFormat.func_146179_b());
            FormattingConfig.entityFormat = StringEscapeUtils.unescapeJava((String)this.entityFormat.func_146179_b());
        }
        if (this.metaFormat.func_146179_b().contains("%s") && this.metaFormat.func_146179_b().contains("%d")) {
            config.setConfig("general", "waila.cfg.metadataformat", this.metaFormat.func_146179_b());
            FormattingConfig.metaFormat = StringEscapeUtils.unescapeJava((String)this.metaFormat.func_146179_b());
        }
        config.setConfig("general", "waila.cfg.bgcolor", OverlayConfig.fromHex(this.backgroundColor.func_146179_b()).getRGB());
        config.setConfig("general", "waila.cfg.gradient1", OverlayConfig.fromHex(this.gradientTop.func_146179_b()).getRGB());
        config.setConfig("general", "waila.cfg.gradient2", OverlayConfig.fromHex(this.gradientBottom.func_146179_b()).getRGB());
        config.setConfig("general", "waila.cfg.fontcolor", OverlayConfig.fromHex(this.textColor.func_146179_b()).getRGB());
        OverlayConfig.updateColors();
    }

    public static class ButtonCycleTheme
    extends GuiButton {
        private static int cachedIndex = 0;
        private final ScreenFormatConfig parent;
        private List<ColorConfig> configs;
        private int index;

        public ButtonCycleTheme(ScreenFormatConfig parent, int buttonId, int x, int y, int widthIn, int heightIn, List<ColorConfig> colorConfigs) {
            super(buttonId, x, y, widthIn, heightIn, "");
            this.configs = colorConfigs;
            this.parent = parent;
            this.index = cachedIndex;
        }

        public ButtonCycleTheme(ScreenFormatConfig parent, int buttonId, int x, int y, List<ColorConfig> colorConfigs) {
            this(parent, buttonId, x, y, 200, 20, colorConfigs);
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            String toDraw = this.configs.get(this.index).getName();
            if (net.minecraft.client.resources.I18n.func_188566_a((String)toDraw)) {
                toDraw = net.minecraft.client.resources.I18n.func_135052_a((String)toDraw, (Object[])new Object[0]);
            }
            if (Keyboard.isKeyDown((int)42)) {
                toDraw = SpecialChars.GREEN + net.minecraft.client.resources.I18n.func_135052_a((String)"screen.button.exporttheme", (Object[])new Object[0]);
            }
            this.field_146126_j = toDraw;
            super.func_146112_a(mc, mouseX, mouseY);
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                if (Keyboard.isKeyDown((int)42)) {
                    ColorConfig config = new ColorConfig(RandomStringUtils.randomAlphanumeric((int)10), OverlayConfig.fromHex(this.parent.backgroundColor.func_146179_b()), OverlayConfig.fromHex(this.parent.gradientTop.func_146179_b()), OverlayConfig.fromHex(this.parent.gradientBottom.func_146179_b()), OverlayConfig.fromHex(this.parent.textColor.func_146179_b()));
                    String json = OverlayConfig.GSON.toJson((Object)config);
                    try {
                        FileWriter fileWriter = new FileWriter(new File(Waila.themeDir, config.getName() + ".json"));
                        fileWriter.write(json);
                        fileWriter.close();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
                ++this.index;
                if (this.index >= this.configs.size()) {
                    this.index = 0;
                }
                cachedIndex = this.index;
                this.configs.get(this.index).apply(this.parent.backgroundColor, this.parent.gradientTop, this.parent.gradientBottom, this.parent.textColor);
                return true;
            }
            return false;
        }
    }
}

