/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.network.MessageReceiveData;
import mcp.mobius.waila.utils.Constants;
import mcp.mobius.waila.utils.NBTUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageRequestTile
implements IMessage {
    public int dim;
    public BlockPos pos;
    public Set<String> keys = Sets.newHashSet();

    public MessageRequestTile() {
    }

    public MessageRequestTile(TileEntity tile, Set<String> keys) {
        this.dim = tile.func_145831_w().field_73011_w.getDimension();
        this.pos = tile.func_174877_v();
        this.keys = keys;
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        int nKeys = buf.readInt();
        for (int i = 0; i < nKeys; ++i) {
            this.keys.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.keys.size());
        for (String key : this.keys) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)key);
        }
    }

    private static String getTileId(TileEntity tile) {
        String id = "";
        try {
            Map classToName = (Map)Constants.TE_CLASS_TO_NAME.get(null);
            id = (String)classToName.get(tile.getClass());
            if (id == null) {
                id = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return id;
    }

    public static class Handler
    implements IMessageHandler<MessageRequestTile, IMessage> {
        public IMessage onMessage(final MessageRequestTile message, final MessageContext ctx) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            server.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    WorldServer world = DimensionManager.getWorld((int)message.dim);
                    if (!world.func_175667_e(message.pos)) {
                        return;
                    }
                    TileEntity tile = world.func_175625_s(message.pos);
                    IBlockState state = world.func_180495_p(message.pos);
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    if (tile == null) {
                        return;
                    }
                    NBTTagCompound tag = new NBTTagCompound();
                    boolean hasNBTBlock = ModuleRegistrar.instance().hasNBTProviders(state.func_177230_c());
                    boolean hasNBTEnt = ModuleRegistrar.instance().hasNBTProviders(tile);
                    if (hasNBTBlock || hasNBTEnt) {
                        tag.func_74768_a("x", message.pos.func_177958_n());
                        tag.func_74768_a("y", message.pos.func_177956_o());
                        tag.func_74768_a("z", message.pos.func_177952_p());
                        tag.func_74778_a("id", MessageRequestTile.getTileId(tile));
                        for (List<IWailaDataProvider> providersList : ModuleRegistrar.instance().getNBTProviders(state.func_177230_c()).values()) {
                            for (IWailaDataProvider provider : providersList) {
                                tag = provider.getNBTData(player, tile, tag, (World)world, message.pos);
                            }
                        }
                        for (List<IWailaDataProvider> providersList : ModuleRegistrar.instance().getNBTProviders(tile).values()) {
                            for (IWailaDataProvider provider : providersList) {
                                tag = provider.getNBTData(player, tile, tag, (World)world, message.pos);
                            }
                        }
                    } else {
                        tag = tile.func_189517_E_();
                        tag = NBTUtil.createTag(tag, message.keys);
                    }
                    tag.func_74768_a("WailaX", message.pos.func_177958_n());
                    tag.func_74768_a("WailaY", message.pos.func_177956_o());
                    tag.func_74768_a("WailaZ", message.pos.func_177952_p());
                    tag.func_74778_a("WailaID", MessageRequestTile.getTileId(tile));
                    Waila.NETWORK_WRAPPER.sendTo((IMessage)new MessageReceiveData(tag), player);
                }
            });
            return null;
        }
    }
}

