/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons;

import jaredbgreat.dldungeons.Difficulty;
import jaredbgreat.dldungeons.GenerationHandler;
import jaredbgreat.dldungeons.builder.Builder;
import jaredbgreat.dldungeons.planner.mapping.MapMatrix;
import jaredbgreat.dldungeons.setup.Externalizer;
import jaredbgreat.dldungeons.themes.ThemeReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public final class ConfigHandler {
    private static File mainConfig;
    private static File themesDir;
    private static File listsDir;
    protected static File configDir;
    private static final int DEFAULT_SCALE = 8;
    private static final int DEFAULT_MINXZ = 16;
    private static final int DEFAULT_DIF = 3;
    private static final int[] DEFAULT_DIMS;
    private static final boolean DEFAULT_WRITE_LISTS = false;
    private static final boolean DEFAULT_NATURAL_SPAWN = true;
    private static final boolean DEFAULT_OBEY_RULE = true;
    private static final boolean DEFAULT_POSITIVE_DIMS = true;
    private static final boolean DEFAULT_ANNOUNCE_COMMANDS = true;
    private static final boolean DEFAULT_VANILLA_LOOT = false;
    private static final boolean DEFAULT_STINGY_LOOT = false;
    private static final boolean EASY_FIND = false;
    private static final boolean DISABLE_API = false;
    private static final boolean NO_MOB_CHANGES = false;
    public static boolean disableAPI;
    public static boolean noMobChanges;
    private static final String[] NEVER_IN_BIOMES;
    private static String[] neverInBiomes;
    public static EnumSet<BiomeDictionary.Type> biomeExclusions;
    protected static boolean writeLists;
    protected static boolean naturalSpawn;
    protected static boolean obeyRule;
    protected static boolean positiveDims;
    public static boolean easyFind;
    public static boolean announceCommands;
    public static boolean vanillaLoot;
    public static boolean stingyLoot;
    private static final boolean PROFILE = false;
    protected static boolean profile;
    private static final boolean INSTALL_THEMES = true;
    public static boolean installThemes;
    private static final boolean INSTALL_CMD = true;
    public static boolean installCmd;
    public static Difficulty difficulty;

    private ConfigHandler() {
    }

    public static void init() {
        int i;
        File file = new File(configDir.toString() + File.separator + "DLDungeonsJBG" + ".cfg");
        Configuration config = new Configuration(file);
        config.load();
        int freqScale = config.get("General", "FrequencyScale", 8).getInt();
        if (freqScale > 30 || freqScale < 4) {
            freqScale = 8;
        }
        GenerationHandler.setFrequency(freqScale);
        System.out.println("[DLDUNGEONS] Frequency Scaling Factor Set To: " + freqScale);
        int minXZ = config.get("General", "MinChunkXY", 16).getInt();
        if (minXZ < 0) {
            minXZ = 16;
        }
        GenerationHandler.setMinXZ(minXZ);
        System.out.println("[DLDUNGEONS] Minimum X Factor Set To: " + minXZ);
        int diff = config.get("General", "Difficulty", 3).getInt();
        if (diff < 0 || diff > 5) {
            diff = 3;
        }
        ConfigHandler.parseDiff(diff);
        System.out.println("[DLDUNGEONS] Difficulty set to: " + ConfigHandler.difficulty.label);
        int[] dims = config.get("General", "Dimensions", DEFAULT_DIMS).getIntList();
        GenerationHandler.setDimensions(dims);
        System.out.print("[DLDUNGEONS] Dimensions listed in config file: ");
        for (i = 0; i < dims.length; ++i) {
            System.out.print(dims[i] + ", ");
        }
        System.out.println();
        naturalSpawn = config.get("General", "SpawnWithWordgen", true).getBoolean(true);
        System.out.println("[DLDUNGEONS] Will spawn dungeons in with world generation? " + naturalSpawn);
        obeyRule = config.get("General", "ObeyFeatureSpawningRule", true).getBoolean(true);
        System.out.println("[DLDUNGEONS] Will spawn dungeons even with structures disabled? " + !obeyRule);
        positiveDims = config.get("General", "OnlySpawnInListedDims", true).getBoolean(true);
        if (positiveDims) {
            System.out.print("[DLDUNGEONS] Will only spawn in these dimensions: ");
        } else {
            System.out.print("[DLDUNGEONS] Will never spawn in these dimensions: ");
        }
        for (i = 0; i < dims.length; ++i) {
            System.out.print(dims[i] + ", ");
        }
        System.out.println();
        writeLists = config.get("General", "ExportLists", false).getBoolean(false);
        System.out.println("[DLDUNGEONS] Will export item, block, and mob lists? " + writeLists);
        announceCommands = config.get("General", "AnnounceCommands", true).getBoolean(true);
        System.out.println("[DLDUNGEONS] Will announce use of OP/cheat commands? " + announceCommands);
        easyFind = config.get("General", "EasyFind", false).getBoolean(false);
        System.out.println("[DLDUNGEONS] Will dungeons be easy to find? " + easyFind);
        installThemes = config.get("General", "InstallThemes", true).getBoolean(true);
        System.out.println("[DLDUNGEONS] Will themes be automatically install if themes folder is empty? " + installThemes);
        installCmd = config.get("General", "InstallThemesByCommand", true).getBoolean(true);
        System.out.println("[DLDUNGEONS] Can themes be (re)installed by command? " + installCmd);
        stingyLoot = config.get("General", "StingyWithLoot", false).getBoolean(false);
        System.out.println("[DLDUNGEONS] Will be stingy with chests? " + stingyLoot);
        neverInBiomes = config.get("General", "NeverInBiomeTypes", NEVER_IN_BIOMES).getStringList();
        ConfigHandler.processBiomeExclusions(neverInBiomes);
        disableAPI = config.get("API", "DisableApiCalls", false).getBoolean(false);
        System.out.println("[DLDUNGEONS] Will use API? " + !disableAPI);
        noMobChanges = config.get("API", "DontAllowApiOnMobs", false).getBoolean(false);
        System.out.println("[DLDUNGEONS] Will allow API base mob change? " + !noMobChanges);
        Builder.setDebugPole(config.get("Debugging", "BuildPole", false).getBoolean(false));
        MapMatrix.setDrawFlyingMap(config.get("Debugging", "BuildFlyingMap", false).getBoolean(false));
        profile = config.get("Debugging", "AutoProfilingOn", false).getBoolean(false);
        System.out.println("[DLDUNGEONS] Will self-profile? " + profile);
        ConfigHandler.openThemesDir();
        config.save();
    }

    protected static void reload() {
        ConfigHandler.init();
    }

    public static void generateLists() {
        if (!writeLists) {
            return;
        }
        listsDir = new File(configDir.toString() + File.separator + "lists");
        if (!listsDir.exists()) {
            listsDir.mkdir();
        }
        if (!listsDir.exists()) {
            System.out.println("[DLDUNGEONS] Warning: Could not create " + listsDir + ".");
        } else if (!listsDir.isDirectory()) {
            System.out.println("[DLDUNGEONS] Warning: " + listsDir + " is not a directory (folder); no themes loaded.");
        } else {
            ConfigHandler.listMobs();
            ConfigHandler.listItems();
            ConfigHandler.listBlocks();
        }
    }

    public static void listMobs() {
        ArrayList mobNames = new ArrayList();
        mobNames.addAll(EntityList.func_180124_b());
        Collections.sort(mobNames);
        BufferedWriter outstream = null;
        File moblist = new File(listsDir.toString() + File.separator + "mobs.txt");
        if (moblist.exists()) {
            moblist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(moblist.toString()));
            for (String name : mobNames) {
                Class A = EntityList.func_90035_a((int)EntityList.func_180122_a((String)name));
                if (!EntityLiving.class.isAssignableFrom(A) || Modifier.isAbstract(A.getModifiers())) continue;
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void listItems() {
        BufferedWriter outstream = null;
        File itemlist = new File(listsDir.toString() + File.separator + "itmes.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            for (Object item : Item.field_150901_e) {
                String name = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)((Item)item))).toString();
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("[DLDUNGEONS] Error: Could not write file items.txt");
            e.printStackTrace();
        }
    }

    public static void listBlocks() {
        BufferedWriter outstream = null;
        File itemlist = new File(listsDir.toString() + File.separator + "blocks.txt");
        if (itemlist.exists()) {
            itemlist.delete();
        }
        try {
            outstream = new BufferedWriter(new FileWriter(itemlist.toString()));
            for (Object block : Block.field_149771_c) {
                String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)((Block)block))).toString();
                outstream.write(name);
                outstream.newLine();
            }
            if (outstream != null) {
                outstream.close();
            }
        }
        catch (IOException e) {
            System.err.println("[DLDUNGEONS] Error: Could not write file blocks.txt");
            e.printStackTrace();
        }
    }

    private static void openThemesDir() {
        File nbtconf;
        Externalizer exporter;
        String themesDirName = configDir.toString() + File.separator + "themes" + File.separator;
        System.out.println("[DLDUNGEONS] themesdir will be set to " + themesDirName);
        themesDir = new File(themesDirName);
        System.out.println("[DLDUNGEONS] themesdir File is be set to " + themesDir);
        if (!themesDir.exists()) {
            themesDir.mkdir();
        }
        if (!themesDir.exists()) {
            System.out.println("[DLDUNGEONS] Warning: Could not create " + themesDirName + ".");
        } else if (!themesDir.isDirectory()) {
            System.out.println("[DLDUNGEONS] Warning: " + themesDirName + " is not a directory (folder); no themes loaded.");
        } else {
            ThemeReader.setThemesDir(themesDir);
        }
        File chests = new File(configDir.toString() + File.separator + "chest.cfg");
        if (!chests.exists()) {
            exporter = new Externalizer(configDir.toString() + File.separator);
            exporter.makeChestCfg();
        }
        if (!(nbtconf = new File(configDir.toString() + File.separator + "nbt.cfg")).exists()) {
            exporter = new Externalizer(configDir.toString() + File.separator);
            exporter.makeNBTCfg();
        }
    }

    protected static void parseDiff(int diff) {
        switch (diff) {
            case 0: {
                difficulty = Difficulty.NONE;
                break;
            }
            case 1: {
                difficulty = Difficulty.BABY;
                break;
            }
            case 2: {
                difficulty = Difficulty.NOOB;
                break;
            }
            case 4: {
                difficulty = Difficulty.HARD;
                break;
            }
            case 5: {
                difficulty = Difficulty.NUTS;
                break;
            }
            default: {
                difficulty = Difficulty.NORM;
            }
        }
    }

    public static File findConfigDir(File fd) {
        File out = new File(fd.toString() + File.separator + "DLDungeonsJBG");
        if (!out.exists()) {
            out.mkdir();
        }
        if (!out.exists()) {
            System.err.println("[DLDUNGEONS] ERROR: Could not create config directory");
        } else if (!out.isDirectory()) {
            System.err.println("[DLDUNGEONS] ERROR: Config directory is not a directory!");
        } else {
            configDir = out;
            ThemeReader.setConfigDir(out);
        }
        return out;
    }

    private static void processBiomeExclusions(String[] array) {
        for (String str : array) {
            str = str.toUpperCase();
            System.out.println("[DLDUNGEONS] adding " + str + " to excusion list");
            try {
                BiomeDictionary.Type value = BiomeDictionary.Type.valueOf((String)str);
                if (value == null) continue;
                biomeExclusions.add(value);
            }
            catch (Exception e) {
                System.err.println("[DLDUNGEONS] Error in config! " + str + " is not valid biome dictionary type!");
                e.printStackTrace();
            }
        }
    }

    public static String getConfigDir() {
        return configDir + File.separator;
    }

    static {
        DEFAULT_DIMS = new int[]{0, -1};
        disableAPI = false;
        noMobChanges = false;
        NEVER_IN_BIOMES = new String[]{"END"};
        neverInBiomes = NEVER_IN_BIOMES;
        biomeExclusions = EnumSet.noneOf(BiomeDictionary.Type.class);
        writeLists = false;
        naturalSpawn = true;
        obeyRule = true;
        positiveDims = true;
        easyFind = false;
        announceCommands = true;
        vanillaLoot = false;
        stingyLoot = false;
        installThemes = true;
        installCmd = true;
    }
}

