/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons;

import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.GenerationHandler;
import jaredbgreat.dldungeons.commands.CmdDimID;
import jaredbgreat.dldungeons.commands.CmdForceInstallThemes;
import jaredbgreat.dldungeons.commands.CmdInstallThemes;
import jaredbgreat.dldungeons.commands.CmdReload;
import jaredbgreat.dldungeons.commands.CmdSpawn;
import jaredbgreat.dldungeons.debug.DLDProfile;
import jaredbgreat.dldungeons.debug.DoNothing;
import jaredbgreat.dldungeons.debug.IProfiler;
import jaredbgreat.dldungeons.themes.ThemeReader;
import jaredbgreat.dldungeons.themes.ThemeType;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(modid="dldungeonsjdg", name="Doomlike Dungeons", version="1.9.2", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.10]")
public class DoomlikeDungeons {
    private static GenerationHandler dungeonPlacer;
    public static IProfiler profiler;
    @Mod.Instance(value="dldungeonsjdg")
    public static DoomlikeDungeons instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        System.out.println("Doomlike Dungeons is in preInit, should now load config.");
        ConfigHandler.configDir = ConfigHandler.findConfigDir(event.getModConfigurationDirectory());
        ConfigHandler.init();
        System.out.println("[DLDUNGEONS] Config should now be loaded.");
        profiler = ConfigHandler.profile ? new DLDProfile() : new DoNothing();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (ConfigHandler.naturalSpawn) {
            dungeonPlacer = new GenerationHandler();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ConfigHandler.generateLists();
        ThemeReader.readThemes();
        ThemeType.SyncMobLists();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CmdSpawn());
        event.registerServerCommand((ICommand)new CmdReload());
        event.registerServerCommand((ICommand)new CmdDimID());
        if (ConfigHandler.installCmd) {
            event.registerServerCommand((ICommand)new CmdInstallThemes());
            event.registerServerCommand((ICommand)new CmdForceInstallThemes());
        }
    }
}

