/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.api;

import jaredbgreat.dldungeons.ReadAPI;
import jaredbgreat.dldungeons.themes.ThemeType;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class DLDungeonsAPI {
    private static final boolean dldloaded = DLDungeonsAPI.isLoaded();

    public static boolean isLoaded() {
        return Loader.isModLoaded((String)"DLDungeonsJBG") || Loader.isModLoaded((String)"dldungeonsjbg");
    }

    public static void spawnDungeon(World world, int chunkX, int chunkZ) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.spawnDungeon(world, chunkX, chunkZ);
    }

    public static void spawnDungeon(World world, int chunkX, int chunkZ, long seed) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.spawnDungeon(world, chunkX, chunkZ, seed);
    }

    public static void spawnDungeon(World world, int chunkX, int chunkZ, Random random) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.spawnDungeon(world, chunkX, chunkZ, random);
    }

    public static void addDimension(byte dim) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.addDimension(dim);
    }

    public static void subDimension(byte dim) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.subDimension(dim);
    }

    public static void setDimensions(int[] dims) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.setDimensions(dims);
    }

    public static void setDifficulty(byte diff) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.setDifficulty(diff);
    }

    public static void loadTheme(String file) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.loadTheme(file);
    }

    @Deprecated
    public static void blacklistThemes() {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.blacklistDimensions();
    }

    public static void blacklistDimensions() {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.blacklistDimensions();
    }

    public static void whitelistDimensions() {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.whitelistDimensions();
    }

    public static void reloadConfig() {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        ReadAPI.whitelistDimensions();
    }

    public static void addMob(String name, int level, String ... types) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        for (String type : types) {
            ThemeType.addMobToType(name, level, type);
        }
    }

    public static void removeMob(String name, int level, String ... types) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        for (String type : types) {
            ThemeType.removeMobFromType(name, level, type);
        }
    }

    public static void removeMob(String name, String ... types) {
        if (!DLDungeonsAPI.isLoaded()) {
            return;
        }
        for (String type : types) {
            for (int i = 0; i < 5; ++i) {
                ThemeType.removeMobFromType(name, i, type);
            }
        }
    }
}

