/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.pieces.chests.LootItem;
import jaredbgreat.dldungeons.pieces.chests.LootList;
import jaredbgreat.dldungeons.pieces.chests.LootType;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;

public class LootCategory {
    public static final int LEVELS = 7;
    public LootList[] levels = new LootList[7];
    public static LootCategory gear = new LootCategory(new LootList[]{LootList.gear1, LootList.gear2, LootList.gear3, LootList.gear4, LootList.gear5, LootList.gear6, LootList.gear7});
    public static LootCategory heal = new LootCategory(new LootList[]{LootList.heal1, LootList.heal2, LootList.heal3, LootList.heal4, LootList.heal5, LootList.heal6, LootList.heal7});
    public static LootCategory loot = new LootCategory(new LootList[]{LootList.loot1, LootList.loot2, LootList.loot3, LootList.loot4, LootList.loot5, LootList.loot6, LootList.loot7});

    public LootCategory(LootList[] loots) {
        this.levels = loots;
    }

    public static ItemStack getLoot(LootType type, int level, Random random) {
        if (level <= 6) {
            level = Math.min(6, level + random.nextInt(2) - random.nextInt(2));
        }
        if (level < 0) {
            level = 0;
        }
        switch (type) {
            case GEAR: {
                if (level > 6) {
                    level = 6;
                }
                if (random.nextBoolean()) {
                    return LootCategory.getEnchantedGear(level, random);
                }
                return LootCategory.gear.levels[level].getLoot(random).getStack(random);
            }
            case HEAL: {
                if (level > 6) {
                    level = 6;
                }
                return LootCategory.heal.levels[level].getLoot(random).getStack(random);
            }
            case LOOT: {
                if (level > 6 && random.nextBoolean()) {
                    return LootList.special.getLoot(random).getStack(random);
                }
                level = 6;
                if (random.nextInt(10) == 0) {
                    return LootCategory.getEnchantedBook(level, random);
                }
                return LootCategory.loot.levels[level].getLoot(random).getStack(random);
            }
        }
        switch (random.nextInt(3)) {
            case 0: {
                return LootCategory.getLoot(LootType.GEAR, level, random);
            }
            case 1: {
                return LootCategory.getLoot(LootType.HEAL, level, random);
            }
        }
        return LootCategory.getLoot(LootType.LOOT, level, random);
    }

    private static ItemStack getEnchantedGear(int lootLevel, Random random) {
        ItemStack out = null;
        float portion = random.nextFloat() / 2.0f;
        int lootPart = Math.min(6, Math.max(0, (int)((float)lootLevel * (1.0f - portion) + 0.5f)));
        int enchPart = Math.min(30, Math.max(0, (int)((float)lootLevel * portion * 10.0f)));
        LootItem item = LootCategory.gear.levels[lootPart].getLoot(random);
        if (enchPart >= 1 && LootCategory.isEnchantable(item)) {
            out = item.getStack(random);
            out = EnchantmentHelper.func_77504_a((Random)random, (ItemStack)out, (int)enchPart, (boolean)true);
        } else {
            out = LootCategory.gear.levels[lootLevel].getLoot(random).getStack(random);
        }
        return out;
    }

    private static boolean isEnchantable(LootItem in) {
        Item item = in.item;
        return item instanceof ItemSword || item instanceof ItemTool || item instanceof ItemArmor || item instanceof ItemBow;
    }

    private static ItemStack getEnchantedBook(int level, Random random) {
        ItemStack out = new ItemStack(Items.field_151122_aG, 1);
        out = EnchantmentHelper.func_77504_a((Random)random, (ItemStack)out, (int)Math.min(30, (int)((double)level * 7.5)), (boolean)true);
        return out;
    }
}

