/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.debug.Logging;
import jaredbgreat.dldungeons.nbt.NBTHelper;
import jaredbgreat.dldungeons.nbt.tags.ITag;
import jaredbgreat.dldungeons.parser.Tokenizer;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class LootItem {
    Item item;
    int min;
    int max;
    int meta;
    ArrayList<ITag> nbtData;
    public static LootItem stoneSword = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"stone_sword"), 1, 1);
    public static LootItem ironSword = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"iron_sword"), 1, 1);
    public static LootItem diamondSword = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"diamond_sword"), 1, 1);
    public static LootItem bow = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"bow"), 1, 1);
    public static LootItem fewArrows = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"arrow"), 4, 12);
    public static LootItem someArrows = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"arrow"), 8, 16);
    public static LootItem manyArrows = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"arrow"), 16, 48);
    public static LootItem fewTorches = new LootItem(Block.func_149684_b((String)"torch"), 4, 12);
    public static LootItem someToreches = new LootItem(Block.func_149684_b((String)"torch"), 12, 16);
    public static LootItem manyTorches = new LootItem(Block.func_149684_b((String)"torch"), 16, 24);
    public static LootItem leatherHat = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"leather_helmet"), 1, 1);
    public static LootItem goldHat = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"golden_helmet"), 1, 1);
    public static LootItem ironHat = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"iron_helmet"), 1, 1);
    public static LootItem diamondHat = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"diamond_helmet"), 1, 1);
    public static LootItem leatherBoots = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"leather_boots"), 1, 1);
    public static LootItem goldBoots = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"golden_boots"), 1, 1);
    public static LootItem ironBoots = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"iron_boots"), 1, 1);
    public static LootItem diamondBoots = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"diamond_boots"), 1, 1);
    public static LootItem leatherPants = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"leather_leggings"), 1, 1);
    public static LootItem goldPants = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"golden_leggings"), 1, 1);
    public static LootItem ironPants = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"iron_leggings"), 1, 1);
    public static LootItem diamondPants = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"diamond_leggings"), 1, 1);
    public static LootItem leatherChest = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"leather_chestplate"), 1, 1);
    public static LootItem goldChest = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"golden_chestplate"), 1, 1);
    public static LootItem ironChest = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"iron_chestplate"), 1, 1);
    public static LootItem diamondChest = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"diamond_chestplate"), 1, 1);
    public static LootItem someBread = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"bread"), 2, 4);
    public static LootItem moreBread = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"bread"), 4, 8);
    public static LootItem someSteak = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"cooked_beef"), 2, 4);
    public static LootItem moreSteak = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"cooked_beef"), 4, 8);
    public static LootItem someChicken = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"cooked_chicken"), 2, 4);
    public static LootItem moreChicken = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"cooked_chicken"), 4, 8);
    public static LootItem someApples = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"apple"), 1, 3);
    public static LootItem moreApples = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"apple"), 2, 7);
    public static LootItem somePie = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"pumpkin_pie"), 1, 3);
    public static LootItem morePie = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"pumpkin_pie"), 2, 7);
    public static LootItem goldApple = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"golden_apple"), 1, 1);
    public static LootItem goldApples = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"golden_apple"), 1, 3);
    public static LootItem oneGold = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"gold_ingot"), 1, 1);
    public static LootItem someGold = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"gold_ingot"), 2, 5);
    public static LootItem moreGold = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"gold_ingot"), 3, 8);
    public static LootItem someIron = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"iron_ingot"), 1, 8);
    public static LootItem moreIron = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"iron_ingot"), 3, 12);
    public static LootItem oneDiamond = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"iron_ingot"), 1, 1);
    public static LootItem diamonds = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"diamond"), 1, 4);
    public static LootItem manyDiamonds = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"diamond"), 3, 9);
    public static LootItem oneEmerald = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"emerald"), 1, 1);
    public static LootItem emeralds = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"emerald"), 1, 4);
    public static LootItem manyEmerald = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"emerald"), 3, 7);
    public static LootItem saddle = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"saddle"), 1, 1);
    public static LootItem ironBarding = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"iron_horse_armor"), 1, 1);
    public static LootItem goldBarding = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"golden_horse_armor"), 1, 1);
    public static LootItem diamondBard = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"diamond_horse_armor"), 1, 1);
    public static LootItem book = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"book"), 1, 1);
    public static LootItem someBooks = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"book"), 2, 5);
    public static LootItem moreBooks = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"book"), 3, 8);
    public static LootItem nameTag = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"name_tag"), 1, 1);
    public static LootItem enderpearl = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"ender_pearl"), 1, 2);
    public static LootItem enderpearls = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"ender_pearl"), 1, 9);
    public static LootItem eyeOfEnder = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"ender_eye"), 1, 2);
    public static LootItem blazeRod = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"blaze_rod"), 1, 2);
    public static LootItem netherstar = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"nether_star"), 1, 1);
    public static LootItem disc13 = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"record_13"), 1, 1);
    public static LootItem discCat = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"record_cat"), 1, 1);
    public static LootItem discBlocks = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"record_blocks"), 1, 1);
    public static LootItem discChirp = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"stone_chirp"), 1, 1);
    public static LootItem discFar = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"record_far"), 1, 1);
    public static LootItem discMall = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"record_mall"), 1, 1);
    public static LootItem discMellohi = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"record_mellohi"), 1, 1);
    public static LootItem discStrad = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"record_strad"), 1, 1);
    public static LootItem discWard = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"record_ward"), 1, 1);
    public static LootItem disc11 = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"record_11"), 1, 1);
    public static LootItem discWait = new LootItem(GameRegistry.findItem((String)"minecraft", (String)"record_wait"), 1, 1);

    public LootItem(String id, int min, int max) {
        this.metaParse(id);
        if (min > max) {
            min = max;
        }
        this.min = min;
        this.max = max;
        if (this.item == null) {
            Logging.LogError("[DLDUNGEONS] ERROR! Item read as \"" + id + "\" was was not in registry (returned null).");
        }
    }

    public LootItem(Item item, int min, int max) {
        this.item = item;
        if (min > max) {
            min = max;
        }
        this.min = min;
        this.max = max;
    }

    public LootItem(Block item, int min, int max) {
        this.item = Item.func_150898_a((Block)item);
        if (min > max) {
            min = max;
        }
        this.min = min;
        this.max = max;
    }

    private void metaParse(String in) {
        Tokenizer tokens = new Tokenizer(in, "({[:]})");
        String modid = tokens.nextToken();
        String name = tokens.nextToken();
        this.item = GameRegistry.findItem((String)modid, (String)name);
        if (this.item == null) {
            Logging.LogError("[DLDUNGEONS] ERROR! Item read as \"" + in + "\" was was not in registry (returned null).");
        }
        if (tokens.hasMoreTokens()) {
            this.meta = Integer.parseInt(tokens.nextToken());
        }
    }

    public void addNbt(String in) {
        if (this.nbtData == null) {
            this.nbtData = new ArrayList();
        }
        this.nbtData.add(NBTHelper.getTagFromLabel(in));
    }

    public void trimNbt() {
        if (this.nbtData != null) {
            this.nbtData.trimToSize();
        }
    }

    public ItemStack getStack(Random random) {
        ItemStack out = this.max <= this.min ? (this.item instanceof Item ? new ItemStack(this.item, this.max) : new ItemStack(this.item, this.max)) : (this.item instanceof Item ? new ItemStack(this.item, random.nextInt(this.max - this.min) + this.min + 1) : new ItemStack(this.item, random.nextInt(this.max - this.min) + this.min + 1));
        if (out.func_77973_b() == null) {
            return null;
        }
        if (out.func_77981_g() && this.meta >= 0) {
            out.func_77964_b(this.meta);
        } else {
            out.func_77964_b(0);
        }
        if (this.nbtData != null && !this.nbtData.isEmpty()) {
            for (ITag tag : this.nbtData) {
                NBTHelper.setNbtTag(out, tag);
            }
        }
        return out;
    }
}

