/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces.chests;

import jaredbgreat.dldungeons.ConfigHandler;
import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.pieces.chests.BasicChest;
import jaredbgreat.dldungeons.pieces.chests.LootCategory;
import jaredbgreat.dldungeons.pieces.chests.LootList;
import jaredbgreat.dldungeons.pieces.chests.LootType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TreasureChest
extends BasicChest {
    static ArrayList<Integer> slots = new ArrayList();
    int slot;

    public TreasureChest(int x, int y, int z, int level) {
        super(x, y, z, level);
    }

    @Override
    public void place(World world, int x, int y, int z, Random random) {
        ItemStack treasure;
        int i;
        BlockPos pos = new BlockPos(x, y, z);
        Collections.shuffle(slots, random);
        this.slot = 0;
        this.level += random.nextInt(2);
        if (this.level >= 7) {
            this.level = 6;
        }
        if (world.func_180495_p(pos).func_177230_c() != DBlock.chest) {
            System.err.println("[DLDUNGEONS] ERROR! Trying to put loot into non-chest at " + x + ", " + y + ", " + z + " (treasure chest).");
            return;
        }
        TileEntityChest contents = (TileEntityChest)world.func_175625_s(pos);
        int num = random.nextInt(3 + this.level / 3) + 2;
        for (i = 0; i < num; ++i) {
            treasure = LootCategory.getLoot(LootType.HEAL, this.level, random);
            contents.func_70299_a(slots.get(this.slot).intValue(), treasure);
            ++this.slot;
        }
        num = random.nextInt(3 + this.level / 3) + 2;
        for (i = 0; i < num; ++i) {
            treasure = LootCategory.getLoot(LootType.GEAR, this.level, random);
            contents.func_70299_a(slots.get(this.slot).intValue(), treasure);
            ++this.slot;
        }
        num = ConfigHandler.stingyLoot ? random.nextInt(3 + this.level / 3) + 2 : random.nextInt(3 + this.level / 2) + 2;
        for (i = 0; i < num; ++i) {
            treasure = LootCategory.getLoot(LootType.LOOT, this.level, random);
            contents.func_70299_a(slots.get(this.slot).intValue(), treasure);
            ++this.slot;
        }
        if (random.nextInt(7) < this.level) {
            treasure = this.level >= 6 ? LootList.special.getLoot(random).getStack(random) : LootList.discs.getLoot(random).getStack(random);
            contents.func_70299_a(slots.get(this.slot).intValue(), treasure);
            ++this.slot;
        }
    }

    private boolean validSlot(int slot) {
        return slot >= 0 && slot < 27;
    }

    public static void initSlots() {
        for (int i = 0; i < 27; ++i) {
            slots.add(new Integer(i));
        }
    }
}

