/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.client;

import com.google.common.primitives.SignedBytes;
import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.TileEntityIronChest;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderEntityItem;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class TileEntityIronChestRenderer
extends TileEntitySpecialRenderer<TileEntityIronChest> {
    private Random random;
    private RenderEntityItem itemRenderer;
    private ModelChest model = new ModelChest();
    private static float[][] shifts = new float[][]{{0.3f, 0.45f, 0.3f}, {0.7f, 0.45f, 0.3f}, {0.3f, 0.45f, 0.7f}, {0.7f, 0.45f, 0.7f}, {0.3f, 0.1f, 0.3f}, {0.7f, 0.1f, 0.3f}, {0.3f, 0.1f, 0.7f}, {0.7f, 0.1f, 0.7f}, {0.5f, 0.32f, 0.5f}};
    private static EntityItem customitem = new EntityItem(null);
    private static float halfPI = 1.5707964f;

    public TileEntityIronChestRenderer() {
        this.random = new Random();
    }

    public void renderTileEntityAt(TileEntityIronChest te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (te == null || te.func_145837_r()) {
            return;
        }
        EnumFacing facing = EnumFacing.SOUTH;
        IronChestType type = te.getType();
        if (te.func_145830_o() && te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c() == IronChest.ironChestBlock) {
            facing = te.getFacing();
            IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
            type = (IronChestType)((Object)state.func_177229_b(BlockIronChest.VARIANT_PROP));
        }
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(type.modelTexture);
        }
        GlStateManager.func_179094_E();
        if (type == IronChestType.CRYSTAL) {
            GlStateManager.func_179129_p();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        switch (facing) {
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            default: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float lidangle = te.prevLidAngle + (te.lidAngle - te.prevLidAngle) * partialTicks;
        lidangle = 1.0f - lidangle;
        lidangle = 1.0f - lidangle * lidangle * lidangle;
        if (type.isTransparent()) {
            GlStateManager.func_179152_a((float)1.0f, (float)0.99f, (float)1.0f);
        }
        this.model.field_78234_a.field_78795_f = -lidangle * halfPI;
        this.model.func_78231_a();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
        if (type == IronChestType.CRYSTAL) {
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type.isTransparent() && te.func_145835_a(this.field_147501_a.field_147560_j, this.field_147501_a.field_147561_k, this.field_147501_a.field_147558_l) < 128.0) {
            this.random.setSeed(254L);
            int shift = 0;
            float blockScale = 0.7f;
            float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0) - partialTicks;
            if (te.getTopItemStacks()[1] == null) {
                shift = 8;
                blockScale = 0.85f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            customitem.func_70029_a(this.func_178459_a());
            TileEntityIronChestRenderer.customitem.field_70290_d = 0.0f;
            for (ItemStack item : te.getTopItemStacks()) {
                if (shift > shifts.length) break;
                if (item == null) {
                    ++shift;
                    continue;
                }
                float shiftX = shifts[shift][0];
                float shiftY = shifts[shift][1];
                float shiftZ = shifts[shift][2];
                ++shift;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)shiftX, (float)shiftY, (float)shiftZ);
                GlStateManager.func_179114_b((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)blockScale, (float)blockScale, (float)blockScale);
                customitem.func_92058_a(item);
                if (this.itemRenderer == null) {
                    this.itemRenderer = new RenderEntityItem(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()){

                        public int func_177078_a(ItemStack stack) {
                            return SignedBytes.saturatedCast((long)(Math.min(stack.field_77994_a / 32, 15) + 1));
                        }

                        public boolean shouldBob() {
                            return false;
                        }

                        public boolean shouldSpreadItems() {
                            return true;
                        }
                    };
                }
                this.itemRenderer.func_76986_a(customitem, 0.0, 0.0, 0.0, 0.0f, partialTicks);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }
}

