/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

public class FontRainbow
extends FontRenderer {
    public static FontRainbow INSTANCE = new FontRainbow();
    private float hue;
    private float r;
    private float g;
    private float b;
    private float a;
    private boolean firstLine;
    private boolean firstLineOnly;

    private FontRainbow() {
        super(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().func_110434_K(), Minecraft.func_71410_x().func_152349_b());
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public int func_175063_a(@Nonnull String text, float x, float y, int color) {
        int length = super.func_175063_a(text, x, y, color);
        this.firstLine = false;
        return length;
    }

    public void func_78279_b(@Nonnull String str, int x, int y, int wrapWidth, int textColor) {
        super.func_78279_b(str, x, y, wrapWidth, textColor);
        this.firstLine = false;
    }

    public FontRainbow init(boolean firstLineOnly) {
        this.hue = (float)((int)(Minecraft.func_71386_F() / 80L)) / 16.0f;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.func_78264_a(fontRenderer.func_82883_a());
        this.func_78275_b(fontRenderer.func_78260_a());
        this.firstLine = true;
        this.firstLineOnly = firstLineOnly;
        return this;
    }

    protected void setColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.setHueColor();
    }

    protected float func_78266_a(int ch, boolean italic) {
        this.advanceHue();
        this.setHueColor();
        return super.func_78266_a(ch, italic);
    }

    private void advanceHue() {
        this.hue += 0.0625f;
    }

    private void setHueColor() {
        int rgb = Color.HSBtoRGB(this.hue, 1.0f, 1.0f);
        if (!this.firstLine && this.firstLineOnly) {
            super.setColor(this.r, this.g, this.b, this.a);
            return;
        }
        if (this.r == this.g && this.g == this.b) {
            super.setColor(this.r * ColorHelper.getRF(rgb), this.g * ColorHelper.getGF(rgb), this.b * ColorHelper.getBF(rgb), this.a);
        } else {
            super.setColor(this.r * 0.5f * (1.0f + ColorHelper.getRF(rgb)), this.g * 0.5f * (1.0f + ColorHelper.getGF(rgb)), this.b * 0.5f * (1.0f + ColorHelper.getBF(rgb)), this.a);
        }
    }

    protected float func_78277_a(char ch, boolean italic) {
        this.advanceHue();
        this.setHueColor();
        return super.func_78277_a(ch, italic);
    }
}

