/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting;

import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.compatibility.XUShapedRecipe;
import com.rwtema.extrautils2.compatibility.XUShapelessRecipe;
import com.rwtema.extrautils2.crafting.AlwaysLast;
import com.rwtema.extrautils2.utils.LogHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CraftingHelper {
    public static final ThreadLocal<Collection<? super IRecipe>> recipeCallback = new ThreadLocal();
    private static final Set<Class<? extends IRecipe>> registeredRecipes = new HashSet<Class<? extends IRecipe>>();

    public static void addRecipe(IRecipe recipe) {
        Collection<? super IRecipe> objects = recipeCallback.get();
        if (objects != null) {
            objects.add((IRecipe)recipe);
        }
        CraftingHelper.registerRecipe(recipe.getClass());
        CompatHelper112.addRecipe(recipe);
    }

    public static ResourceLocation createLocation(String string) {
        return new ResourceLocation("extrautils2", string.toLowerCase(Locale.ENGLISH));
    }

    public static void addShapeless(String location, ItemStack stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapelessRecipe(CraftingHelper.createLocation(location), stack, recipe));
    }

    public static void addShaped(String location, ItemStack stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapedRecipe(CraftingHelper.createLocation(location), stack, recipe));
    }

    public static void addShapeless(String location, Item stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapelessRecipe(CraftingHelper.createLocation(location), stack, recipe));
    }

    public static void addShaped(String location, Item stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapedRecipe(CraftingHelper.createLocation(location), stack, recipe));
    }

    public static void addShapeless(String location, Block stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapelessRecipe(CraftingHelper.createLocation(location), stack, recipe));
    }

    public static void addShaped(String location, Block stack, Object ... recipe) {
        CraftingHelper.addRecipe((IRecipe)new XUShapedRecipe(CraftingHelper.createLocation(location), stack, recipe));
    }

    public static void registerRecipe(Class<? extends IRecipe> recipe) {
        if (registeredRecipes.contains(recipe)) {
            return;
        }
        if (!recipe.getName().startsWith("com.rwtema.")) {
            return;
        }
        registeredRecipes.add(recipe);
        LogHelper.fine("Registering " + recipe.getSimpleName() + " to RecipeSorter", new Object[0]);
        if (ShapedOreRecipe.class.isAssignableFrom(recipe)) {
            RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
        } else if (ShapelessOreRecipe.class.isAssignableFrom(recipe)) {
            RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore before:extrautils2:alwaysLastShapeless");
        } else if (ShapedRecipes.class.isAssignableFrom(recipe)) {
            RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        } else if (ShapelessRecipes.class.isAssignableFrom(recipe)) {
            RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless before:extrautils2:alwaysLastShapeless");
        } else {
            RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        }
    }

    public static void registerRecipe(Class<? extends IRecipe> recipe, RecipeSorter.Category cat, String s) {
        if (registeredRecipes.contains(recipe)) {
            return;
        }
        registeredRecipes.add(recipe);
        RecipeSorter.register((String)("extrautils2:" + recipe.getSimpleName()), recipe, (RecipeSorter.Category)cat, (String)s);
    }

    public static void addIngotBlockPackingRecipes(String base, ItemStack ingot, ItemStack block) {
        CraftingHelper.addShaped(base + "_ingot_to_block", StackHelper.safeCopy(block), "sss", "sss", "sss", Character.valueOf('s'), StackHelper.safeCopy(ingot));
        CraftingHelper.addShapeless(base + "_block_to_ingot", ItemHandlerHelper.copyStackWithSize((ItemStack)ingot, (int)9), block.func_77946_l());
    }

    static {
        registeredRecipes.add(AlwaysLast.XUShapedRecipeAlwaysLast.class);
        RecipeSorter.register((String)"extrautils2:alwaysLastShaped", AlwaysLast.XUShapedRecipeAlwaysLast.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shaped after:minecraft:shapeless after:forge:shapedore after:forge:shapelessore after:minecraft:repair after:minecraft:pattern_add after:minecraft:mapextending after:minecraft:armordyes after:minecraft:fireworks after:minecraft:bookcloning");
        registeredRecipes.add(AlwaysLast.XUShapelessRecipeAlwaysLast.class);
        RecipeSorter.register((String)"extrautils2:alwaysLastShapeless", AlwaysLast.XUShapedRecipeAlwaysLast.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shaped after:minecraft:shapeless after:forge:shapedore after:forge:shapelessore after:minecraft:repair after:minecraft:pattern_add after:minecraft:mapextending after:minecraft:armordyes after:minecraft:fireworks after:minecraft:bookcloning");
    }
}

