/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.api.recipes.IRecipeInfoWrapper;
import com.rwtema.extrautils2.backend.ISidedFunction;
import com.rwtema.extrautils2.compatibility.RecipeCompat;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.IItemMatcher;
import com.rwtema.extrautils2.gui.backend.WidgetCraftingMatrix;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public abstract class PlayerSpecificCrafting
implements RecipeCompat,
IRecipeInfoWrapper<IRecipe> {
    public final IRecipe recipe;
    public final IItemMatcher matcher;
    ResourceLocation location;

    public PlayerSpecificCrafting(ResourceLocation location, IRecipe recipe) {
        this.location = location;
        this.recipe = recipe;
        Validate.notNull((Object)recipe.func_77571_b());
        this.matcher = recipe instanceof IItemMatcher ? (IItemMatcher)recipe : IItemMatcher.CRAFTING;
    }

    @Override
    public int getRecipeSize() {
        return RecipeCompat.getRecipeSize(this.recipe);
    }

    public ItemStack func_77571_b() {
        return this.recipe.func_77571_b();
    }

    @Override
    @Nonnull
    public ItemStack[] getRemainingItemsBase(@Nonnull InventoryCrafting inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : this.recipe.func_179532_b(inv)) {
            stacks.add(itemStack);
        }
        return stacks.toArray(new ItemStack[stacks.size()]);
    }

    public ItemStack func_77572_b(@Nonnull InventoryCrafting var1) {
        if (!this.isGoodForCrafting(var1)) {
            return StackHelper.empty();
        }
        return this.recipe.func_77572_b(var1);
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        return this.recipe.func_77569_a(inv, world);
    }

    public boolean isGoodForCrafting(InventoryCrafting inv) {
        PlayerList manager;
        if (inv instanceof WidgetCraftingMatrix.XUInventoryCrafting) {
            EntityPlayer player = ((WidgetCraftingMatrix.XUInventoryCrafting)inv).player;
            if (player == null) {
                return false;
            }
            if (player instanceof EntityPlayerMP) {
                this.updatePlayer((EntityPlayerMP)player);
            }
            return this.isValidForCrafting(player);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return ExtraUtils2.proxy.apply(new ClientIsGoodForCrafting(inv), null);
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (manager = server.func_184103_al()) != null) {
            Container container = inv.field_70465_c;
            if (container == null) {
                return false;
            }
            EntityPlayerMP foundPlayer = null;
            for (EntityPlayerMP entityPlayerMP : manager.func_181057_v()) {
                if (entityPlayerMP.field_71070_bA != container || !container.func_75145_c((EntityPlayer)entityPlayerMP) || !container.func_75129_b((EntityPlayer)entityPlayerMP)) continue;
                if (foundPlayer != null) {
                    return false;
                }
                foundPlayer = entityPlayerMP;
            }
            if (foundPlayer != null) {
                this.updatePlayer(foundPlayer);
                return this.isValidForCrafting((EntityPlayer)foundPlayer);
            }
        }
        return false;
    }

    protected abstract void updatePlayer(EntityPlayerMP var1);

    protected abstract boolean isValidForCrafting(EntityPlayer var1);

    @Override
    public IRecipe getOriginalRecipe() {
        return this.recipe;
    }

    @Override
    public abstract String info();

    protected abstract void finishedCrafting(EntityPlayer var1, ItemStack var2);

    protected abstract void addTooltip(ItemTooltipEvent var1, ItemStack var2);

    public IRecipe setRegistryName(ResourceLocation name) {
        this.location = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.location;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    @Override
    public boolean canFit(int width, int height) {
        return ((RecipeCompat)this.recipe).canFit(width, height);
    }

    private class ClientIsGoodForCrafting
    implements ISidedFunction<Void, Boolean> {
        private final InventoryCrafting inv;

        public ClientIsGoodForCrafting(InventoryCrafting inv) {
            this.inv = inv;
        }

        @Override
        @SideOnly(value=Side.SERVER)
        public Boolean applyServer(Void input) {
            return false;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Boolean applyClient(Void input) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            return player != null && PlayerSpecificCrafting.this.isValidForCrafting((EntityPlayer)player) && player.field_71070_bA == this.inv.field_70465_c;
        }
    }

    protected class EventHandler {
        protected EventHandler() {
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void tooltip(ItemTooltipEvent event) {
            ItemStack itemStack = event.getItemStack();
            if (itemStack != PlayerSpecificCrafting.this.recipe.func_77571_b()) {
                return;
            }
            PlayerSpecificCrafting.this.addTooltip(event, itemStack);
        }

        @SubscribeEvent
        public void onCraft(PlayerEvent.ItemCraftedEvent event) {
            EntityPlayer player = event.player;
            if (player == null) {
                return;
            }
            ItemStack crafting = event.crafting;
            ItemStack recipeOutput = PlayerSpecificCrafting.this.recipe.func_77571_b();
            if (StackHelper.isNull(crafting) || !PlayerSpecificCrafting.this.matcher.itemsMatch(crafting, (ItemStack)Validate.notNull((Object)recipeOutput))) {
                return;
            }
            PlayerSpecificCrafting.this.finishedCrafting(player, recipeOutput);
        }
    }
}

