/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.entity;

import com.rwtema.extrautils2.backend.model.CachedRenderers;
import com.rwtema.extrautils2.backend.model.IClientClearCache;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.CompatClientHelper;
import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.entity.EntityBoomerang;
import com.rwtema.extrautils2.render.IVertexBuffer;
import com.rwtema.extrautils2.utils.MCTimer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.TRSRTransformation;

public class RenderEntityBoomerang
extends Render<EntityBoomerang>
implements IClientClearCache {
    TextureAtlasSprite sprite;
    List<BakedQuad> model;

    public RenderEntityBoomerang(RenderManager renderManager) {
        super(renderManager);
        CachedRenderers.register(this);
    }

    public static void renderModel(List<BakedQuad> bakedQuads) {
        Tessellator tessellator = Tessellator.func_178181_a();
        IVertexBuffer worldrenderer = CompatClientHelper.wrap(tessellator.func_178180_c());
        worldrenderer.begin(7, DefaultVertexFormats.field_176599_b);
        for (BakedQuad bakedquad : bakedQuads) {
            LightUtil.renderQuadColor((VertexBuffer)CompatClientHelper.unwrap(worldrenderer), (BakedQuad)bakedquad, (int)-1);
        }
        tessellator.func_78381_a();
    }

    public void doRender(@Nonnull EntityBoomerang entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (this.sprite == null) {
            this.sprite = (TextureAtlasSprite)Textures.sprites.get((Object)"boomerang");
            if (this.sprite == null) {
                this.sprite = Textures.MISSING_SPRITE;
            }
            this.model = ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)this.sprite, (VertexFormat)DefaultVertexFormats.field_176599_b, CompatHelper112.optionalOf(TRSRTransformation.identity()));
        }
        boolean flag = false;
        if (this.func_180548_c(entity)) {
            this.field_76990_c.field_78724_e.func_110581_b(this.getEntityTexture(entity)).func_174936_b(false, false);
            flag = true;
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179109_b((float)0.0f, (float)0.125f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks + 90.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(90.0f + MCTimer.renderTimer * 16.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        RenderEntityBoomerang.renderModel(this.model);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        this.func_180548_c(entity);
        if (flag) {
            this.field_76990_c.field_78724_e.func_110581_b(this.getEntityTexture(entity)).func_174935_a();
        }
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    @Nonnull
    protected ResourceLocation getEntityTexture(@Nonnull EntityBoomerang entity) {
        return TextureMap.field_110575_b;
    }

    @Override
    public void clientClear() {
        this.sprite = null;
        this.model = null;
    }
}

