/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.modcompat.tcon;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientRunnable;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.fluids.TexturePlasma;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;

public abstract class XUTinkerMaterial {
    @Nonnull
    public final Material material;
    @Nullable
    public final Fluid fluid;
    @Nonnull
    public final String name;
    public final int color;
    @Nullable
    public final String oreDicSuffix;
    @Nullable
    public final Supplier<ItemStack> representativeStack;
    List<IMaterialStats> stats = new ArrayList<IMaterialStats>();

    public XUTinkerMaterial(final @Nonnull String name, int color, @Nullable String oreDicSuffix, @Nullable Supplier<ItemStack> representativeStack, boolean addFluid) {
        this.name = name;
        this.color = color;
        this.oreDicSuffix = oreDicSuffix;
        this.representativeStack = representativeStack;
        this.material = new Material(name, color);
        if (addFluid) {
            final ResourceLocation still = new ResourceLocation("extrautils2", name);
            ExtraUtils2.proxy.run(new ClientRunnable(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                    Textures.registerSupplier(name, new Supplier<TextureAtlasSprite>(){

                        @Override
                        public TextureAtlasSprite get() {
                            int[] ints = XUTinkerMaterial.this.createPalette();
                            return new TexturePlasma(still.toString(), new ResourceLocation("extrautils2", "molten_fluid_base"), ints);
                        }
                    });
                }
            });
            this.fluid = new Fluid(name, still, still);
            this.fluid.setTemperature(1000);
        } else {
            this.fluid = null;
        }
    }

    public abstract void addTraits();

    public void addTrait(ITrait trait) {
        this.addTrait(trait, null);
    }

    public void addTrait(ITrait trait, String dependency) {
        this.material.addTrait(trait, dependency);
    }

    protected int[] createPalette() {
        return new int[]{ColorHelper.multShade(this.color, 0.8f), this.color};
    }

    public abstract void addStats(List<IMaterialStats> var1);

    @SideOnly(value=Side.CLIENT)
    public abstract MaterialRenderInfo createRenderInfo();

    @SideOnly(value=Side.CLIENT)
    public abstract TextureAtlasSprite createTexture(TextureAtlasSprite var1, String var2);
}

