/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.blocks.BlockCreativeHarvest;
import com.rwtema.extrautils2.compatibility.BlockCompat;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.tile.tesr.ITESREnchantment;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileCreativeHarvest
extends XUTile
implements ITESREnchantment<TileCreativeHarvest> {
    public final NBTSerializable.NBTBlockState mimicState = this.registerNBT("state", new NBTSerializable.NBTBlockState());
    public final NBTSerializable.NBTBoolean pickupable = this.registerNBT("pickupable", new NBTSerializable.NBTBoolean(false));

    @Override
    @Nullable
    public NBTTagCompound getSaveInfo() {
        IBlockState value = this.mimicState.value;
        if (value == null) {
            return null;
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74782_a("creative_block", (NBTBase)this.mimicState.serializeNBT());
        ItemStack stack = value.func_177230_c().func_185473_a(this.field_145850_b, this.field_174879_c, value);
        nbtTagCompound.func_74782_a("display_stack", (NBTBase)stack.serializeNBT());
        return nbtTagCompound;
    }

    @Override
    public void loadSaveInfo(@Nonnull NBTTagCompound tag) {
        if (tag.func_150297_b("creative_block", 10)) {
            this.mimicState.deserializeNBT(tag.func_74775_l("creative_block"));
            if (this.mimicState.value == null) {
                this.mimicState.value = Blocks.field_150348_b.func_176223_P();
            }
            this.pickupable.value = true;
        }
        super.loadSaveInfo(tag);
    }

    @Override
    public boolean shouldShowEnchantment() {
        return this.mimicState.value != null;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.mimicState.value == null && playerIn.field_71075_bZ.field_75098_d) {
            ItemBlock itemblock;
            if (worldIn.field_72995_K) {
                return true;
            }
            ItemStack stack = playerIn.func_184586_b(hand);
            if (StackHelper.isNonNull(stack) && stack.func_77973_b() instanceof ItemBlock && !((itemblock = (ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockCreativeHarvest)) {
                this.mimicState.value = BlockCompat.invokeGetStateForPlacement(itemblock.func_179223_d(), worldIn, pos, side, hitX, hitY, hitZ, itemblock.func_77647_b(stack.func_77960_j()), playerIn, EnumHand.MAIN_HAND, stack);
                this.func_70296_d();
                this.markForUpdate();
            }
            return true;
        }
        if (playerIn.func_70093_af()) {
            if (worldIn.field_72995_K) {
                return true;
            }
            if (!playerIn.field_71075_bZ.field_75098_d && !this.pickupable.value) {
                return true;
            }
            Optional<ItemStack> pickBlock = this.getPickBlock(playerIn, null);
            if (!pickBlock.isPresent()) {
                return true;
            }
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)pickBlock.get());
            worldIn.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)this.getBlockState()));
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        return false;
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        if (this.mimicState.value == null) {
            packet.writeInt(-1);
        } else {
            Block block = this.mimicState.value.func_177230_c();
            packet.writeInt(Block.func_149682_b((Block)block));
            packet.writeByte(block.func_176201_c(this.mimicState.value));
        }
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        int i = packet.readInt();
        this.mimicState.value = null;
        if (i >= 0) {
            IBlockState stateFromMeta;
            short meta = packet.readUnsignedByte();
            Block blockById = Block.func_149729_e((int)i);
            if (blockById != Blocks.field_150350_a && this.mimicState.value != (stateFromMeta = blockById.func_176203_a((int)meta))) {
                this.mimicState.value = stateFromMeta;
                this.markForUpdate();
            }
        }
    }
}

