/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.worldgen;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.utils.LogHelper;
import com.rwtema.extrautils2.worldgen.SingleChunkWorldGenManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public abstract class SingleChunkGen {
    static ThreadLocal<BlockPos.MutableBlockPos> mutableBlockPos = new ThreadLocal<BlockPos.MutableBlockPos>(){

        @Override
        protected BlockPos.MutableBlockPos initialValue() {
            return new BlockPos.MutableBlockPos();
        }
    };
    static IBlockState air = Blocks.field_150350_a.func_176223_P();
    public final int version;
    public final String name;

    protected SingleChunkGen(String name, int version) {
        this.name = name;
        this.version = version;
    }

    public abstract void genChunk(Chunk var1, Object var2, Random var3);

    public boolean shouldRegenOldVersion(int v) {
        return true;
    }

    public boolean isAir(Chunk chunk, BlockPos pos) {
        return chunk.func_177435_g(pos) == air;
    }

    public boolean isAir(Chunk chunk, BlockPos pos, EnumFacing side) {
        return this.isAir(chunk, pos.func_177958_n() + side.func_82601_c(), pos.func_177956_o() + side.func_96559_d(), pos.func_177952_p() + side.func_82599_e());
    }

    public boolean isAir(Chunk chunk, int dx, int dy, int dz) {
        BlockPos.MutableBlockPos pos = mutableBlockPos.get();
        pos.func_181079_c(dx, dy, dz);
        return this.isAir(chunk, (BlockPos)pos);
    }

    public void report(Chunk chunk, int dx, int dy, int dz) {
        if (!ExtraUtils2.deobf_folder) {
            return;
        }
        LogHelper.debug(this.name + " " + new BlockPos((chunk.field_76635_g << 4) + dx, dy, (chunk.field_76647_h << 4) + dz), new Object[0]);
    }

    public void setBlockState(Chunk chunk, BlockPos pos, IBlockState state) {
        if (SingleChunkWorldGenManager.isRetrogen.get().booleanValue()) {
            int i = pos.func_177958_n() & 0xF;
            int j = pos.func_177956_o();
            int k = pos.func_177952_p() & 0xF;
            int l = k << 4 | i;
            ExtendedBlockStorage[] storageArrays = chunk.func_76587_i();
            ExtendedBlockStorage extendedblockstorage = storageArrays[j >> 4];
            Block block = state.func_177230_c();
            if (extendedblockstorage == null) {
                if (block == Blocks.field_150350_a) {
                    return;
                }
                ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(j & 0xFFFFFFF0, CompatHelper.hasSky(chunk.func_177412_p()));
                storageArrays[j >> 4] = extendedBlockStorage;
                extendedblockstorage = extendedBlockStorage;
            }
            extendedblockstorage.func_177484_a(i, j & 0xF, k, state);
        } else {
            chunk.func_177436_a(pos, state);
        }
    }
}

