/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import zmaster587.libVulpes.Configuration;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.cap.ForgePowerCapability;
import zmaster587.libVulpes.cap.TeslaHandler;
import zmaster587.libVulpes.energy.IPower;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class TileEntityRFConsumer
extends TileEntity
implements IPower,
IUniversalEnergy,
ITickable {
    protected UniversalBattery energy;

    protected TileEntityRFConsumer(int energy) {
        this.energy = new UniversalBattery(energy);
    }

    @Override
    public boolean canExtract() {
        return false;
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing arg0) {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || TeslaHandler.hasTeslaCapability((ICapabilityProvider)this, capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)new ForgePowerCapability(this);
        }
        if (TeslaHandler.hasTeslaCapability((ICapabilityProvider)this, capability)) {
            return (T)TeslaHandler.getHandler(this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.energy.writeToNBT(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy.readFromNBT(nbt);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.acceptEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.extractEnergy(maxExtract, simulate);
    }

    public boolean hasEnoughEnergy(int amt) {
        return this.getEnergyStored() >= amt;
    }

    public int getPowerPerOperation() {
        return 0;
    }

    public abstract boolean canPerformFunction();

    public void func_73660_a() {
        if (this.canPerformFunction()) {
            if (this.hasEnoughEnergy((int)Math.max(Configuration.powerMult * (float)this.getPowerPerOperation(), 1.0f))) {
                if (!this.field_145850_b.field_72995_K) {
                    this.energy.extractEnergy(this.getPowerPerOperation(), false);
                }
                this.performFunction();
            } else {
                this.notEnoughEnergyForFunction();
            }
        }
    }

    public abstract void performFunction();

    public void notEnoughEnergyForFunction() {
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean hasEnergy() {
        return this.energy.getEnergyStored() > 0;
    }

    @Override
    public void setEnergyStored(int value) {
        this.energy.setEnergyStored(value);
    }

    @Override
    public int extractEnergy(int amt, boolean simulate) {
        return this.energy.extractEnergy(amt, false);
    }

    @Override
    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public void setMaxEnergyStored(int max) {
        this.energy.setEnergyStored(max);
    }

    @Override
    public int acceptEnergy(int amt, boolean simulate) {
        return this.energy.acceptEnergy(amt, simulate);
    }

    @Override
    public int receiveEnergy(int amt, boolean simulate) {
        return this.energy.acceptEnergy(amt, simulate);
    }
}

