/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import zmaster587.libVulpes.block.BlockTile;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.tile.TileInventoriedForgeProducer;

public abstract class TileInventoriedForgePowerMachine
extends TileInventoriedForgeProducer
implements IProgressBar {
    protected int timeRemaining;
    protected int currentTime;
    protected int lastRFAmount;

    protected TileInventoriedForgePowerMachine(int energy, int invSize) {
        super(energy, invSize);
    }

    @Override
    public boolean canGeneratePower() {
        return this.timeRemaining > 0;
    }

    @Override
    public void onGeneratePower() {
    }

    public int getLastAmtGenerated() {
        return this.lastRFAmount;
    }

    protected void setState(boolean state) {
        if ((Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockTile.STATE) != state) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockTile.STATE, (Comparable)Boolean.valueOf(state)));
        }
    }

    protected void onOperationFinish() {
        this.setState(false);
    }

    @Override
    public void func_73660_a() {
        if (this.canGeneratePower()) {
            if (this.hasEnoughEnergyBuffer(this.getPowerPerOperation())) {
                this.lastRFAmount = this.getPowerPerOperation();
                if (!this.field_145850_b.field_72995_K) {
                    this.energy.acceptEnergy(this.lastRFAmount, false);
                }
                this.onGeneratePower();
                this.setState(true);
                if (this.timeRemaining < this.currentTime++) {
                    this.currentTime = 0;
                    this.timeRemaining = -1;
                    this.onOperationFinish();
                }
            } else {
                this.notEnoughBufferForFunction();
            }
        }
        this.transmitPower();
    }

    @Override
    public void notEnoughBufferForFunction() {
        this.setState(false);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("timeRemaining", this.timeRemaining);
        nbt.func_74768_a("currentTime", this.currentTime);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.timeRemaining = nbt.func_74762_e("timeRemaining");
        this.currentTime = nbt.func_74762_e("currentTime");
    }

    @Override
    public float getNormallizedProgress(int id) {
        return (float)(this.timeRemaining - this.currentTime) / (float)this.timeRemaining;
    }

    @Override
    public void setProgress(int id, int progress) {
        this.currentTime = progress;
    }

    @Override
    public int getProgress(int id) {
        return this.currentTime;
    }

    @Override
    public int getTotalProgress(int id) {
        return this.timeRemaining;
    }

    @Override
    public void setTotalProgress(int id, int progress) {
        this.timeRemaining = progress;
    }
}

