/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileUtil {
    public static boolean isUsableByPlayer(EntityPlayer player, TileEntity tile) {
        if (tile == null) {
            return false;
        }
        BlockPos pos = tile.func_174877_v();
        World world = tile.func_145831_w();
        if (tile.func_145837_r()) {
            return false;
        }
        if (world.func_175625_s(pos) != tile) {
            return false;
        }
        return player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    @Nullable
    public static <T extends TileEntity> T getTile(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull Class<T> tileClass) {
        TileEntity tileEntity;
        if (pos == null) {
            return null;
        }
        if (world instanceof ChunkCache) {
            ChunkCache chunkCache = (ChunkCache)world;
            tileEntity = chunkCache.func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
        } else {
            tileEntity = world.func_175625_s(pos);
        }
        if (tileClass.isInstance(tileEntity)) {
            return (T)((TileEntity)tileClass.cast(tileEntity));
        }
        return null;
    }

    public static IItemHandler getInventoryFromTile(@Nullable TileEntity tile, @Nullable EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (tile instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tile, side);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }
}

