/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.gui.slots.SlotCrafter;
import forestry.core.gui.slots.SlotForestry;
import forestry.core.utils.ItemStackUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;

public abstract class SlotUtil {
    private static final int playerInventorySize = 36;
    private static final int playerHotbarSize = 9;

    public static boolean isSlotInRange(int slotIndex, int start, int count) {
        return slotIndex >= start && slotIndex < start + count;
    }

    public static ItemStack slotClickPhantom(SlotForestry slot, int mouseButton, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack stack = null;
        ItemStack stackSlot = slot.func_75211_c();
        if (stackSlot != null) {
            stack = stackSlot.func_77946_l();
        }
        if (mouseButton == 2) {
            SlotUtil.fillPhantomSlot(slot, null, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1) {
            InventoryPlayer playerInv = player.field_71071_by;
            ItemStack stackHeld = playerInv.func_70445_o();
            if (stackSlot == null) {
                if (stackHeld != null && slot.func_75214_a(stackHeld)) {
                    SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            } else if (stackHeld == null) {
                SlotUtil.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
            } else if (slot.func_75214_a(stackHeld)) {
                if (ItemStackUtil.isIdenticalItem(stackSlot, stackHeld)) {
                    SlotUtil.adjustPhantomSlot(slot, mouseButton, clickTypeIn);
                } else {
                    SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            }
        } else if (mouseButton == 5) {
            InventoryPlayer playerInv = player.field_71071_by;
            ItemStack stackHeld = playerInv.func_70445_o();
            if (!slot.func_75216_d()) {
                SlotUtil.fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        }
        return stack;
    }

    public static ItemStack transferStackInSlot(List inventorySlots, EntityPlayer player, int slotIndex) {
        Slot slot = (Slot)inventorySlots.get(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return null;
        }
        boolean fromCraftingSlot = slot instanceof SlotCrafting || slot instanceof SlotCrafter;
        int numSlots = inventorySlots.size();
        ItemStack stackInSlot = slot.func_75211_c();
        ItemStack originalStack = stackInSlot.func_77946_l();
        if (!SlotUtil.shiftItemStack(inventorySlots, stackInSlot, slotIndex, numSlots, fromCraftingSlot)) {
            return null;
        }
        slot.func_75220_a(stackInSlot, originalStack);
        if (stackInSlot.field_77994_a <= 0) {
            slot.func_75215_d(null);
        } else {
            slot.func_75218_e();
        }
        if (stackInSlot.field_77994_a == originalStack.field_77994_a) {
            return null;
        }
        slot.func_82870_a(player, stackInSlot);
        return originalStack;
    }

    private static boolean shiftItemStack(List inventorySlots, ItemStack stackInSlot, int slotIndex, int numSlots, boolean fromCraftingSlot) {
        if (SlotUtil.isInPlayerInventory(slotIndex)) {
            if (SlotUtil.shiftToMachineInventory(inventorySlots, stackInSlot, numSlots)) {
                return true;
            }
            if (SlotUtil.isInPlayerHotbar(slotIndex)) {
                return SlotUtil.shiftToPlayerInventoryNoHotbar(inventorySlots, stackInSlot);
            }
            return SlotUtil.shiftToHotbar(inventorySlots, stackInSlot);
        }
        if (fromCraftingSlot && SlotUtil.shiftToMachineInventory(inventorySlots, stackInSlot, numSlots)) {
            return true;
        }
        return SlotUtil.shiftToPlayerInventory(inventorySlots, stackInSlot);
    }

    private static void adjustPhantomSlot(SlotForestry slot, int mouseButton, ClickType clickTypeIn) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c();
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.field_77994_a + 1) / 2 : stackSlot.field_77994_a * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.field_77994_a - 1 : stackSlot.field_77994_a + 1;
        }
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        stackSlot.field_77994_a = stackSize;
        if (stackSlot.field_77994_a <= 0) {
            stackSlot = null;
        }
        slot.func_75215_d(stackSlot);
    }

    private static void fillPhantomSlot(SlotForestry slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        if (stackHeld == null) {
            slot.func_75215_d(null);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.field_77994_a : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.field_77994_a = stackSize;
        slot.func_75215_d(phantomStack);
    }

    private static boolean shiftItemStackToRange(List inventorySlots, ItemStack stackToShift, int start, int count) {
        boolean changed = SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackToShift, start, count);
        return changed |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackToShift, start, count);
    }

    private static boolean shiftItemStackToRangeMerge(List inventorySlots, ItemStack stackToShift, int start, int count) {
        if (stackToShift == null || !stackToShift.func_77985_e() || stackToShift.field_77994_a <= 0) {
            return false;
        }
        boolean changed = false;
        for (int slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < start + count; ++slotIndex) {
            Slot slot = (Slot)inventorySlots.get(slotIndex);
            ItemStack stackInSlot = slot.func_75211_c();
            if (stackInSlot == null || !ItemStackUtil.isIdenticalItem(stackInSlot, stackToShift)) continue;
            int resultingStackSize = stackInSlot.field_77994_a + stackToShift.field_77994_a;
            int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
            if (resultingStackSize <= max) {
                stackToShift.field_77994_a = 0;
                stackInSlot.field_77994_a = resultingStackSize;
                slot.func_75218_e();
                changed = true;
                continue;
            }
            if (stackInSlot.field_77994_a >= max) continue;
            stackToShift.field_77994_a -= max - stackInSlot.field_77994_a;
            stackInSlot.field_77994_a = max;
            slot.func_75218_e();
            changed = true;
        }
        return changed;
    }

    private static boolean shiftItemStackToRangeOpenSlots(List inventorySlots, ItemStack stackToShift, int start, int count) {
        if (stackToShift == null || stackToShift.field_77994_a <= 0) {
            return false;
        }
        boolean changed = false;
        for (int slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < start + count; ++slotIndex) {
            Slot slot = (Slot)inventorySlots.get(slotIndex);
            ItemStack stackInSlot = slot.func_75211_c();
            if (stackInSlot != null) continue;
            int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
            stackInSlot = stackToShift.func_77946_l();
            stackInSlot.field_77994_a = Math.min(stackToShift.field_77994_a, max);
            stackToShift.field_77994_a -= stackInSlot.field_77994_a;
            slot.func_75215_d(stackInSlot);
            slot.func_75218_e();
            changed = true;
        }
        return changed;
    }

    private static boolean isInPlayerInventory(int slotIndex) {
        return slotIndex < 36;
    }

    private static boolean isInPlayerHotbar(int slotIndex) {
        return SlotUtil.isSlotInRange(slotIndex, 27, 36);
    }

    private static boolean shiftToPlayerInventory(List inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        boolean shifted = SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackInSlot, playerHotbarStart, 9);
        shifted |= SlotUtil.shiftItemStackToRangeMerge(inventorySlots, stackInSlot, 0, playerHotbarStart);
        shifted |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackInSlot, playerHotbarStart, 9);
        return shifted |= SlotUtil.shiftItemStackToRangeOpenSlots(inventorySlots, stackInSlot, 0, playerHotbarStart);
    }

    private static boolean shiftToPlayerInventoryNoHotbar(List inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        return SlotUtil.shiftItemStackToRange(inventorySlots, stackInSlot, 0, playerHotbarStart);
    }

    private static boolean shiftToHotbar(List inventorySlots, ItemStack stackInSlot) {
        int playerHotbarStart = 27;
        return SlotUtil.shiftItemStackToRange(inventorySlots, stackInSlot, playerHotbarStart, 9);
    }

    private static boolean shiftToMachineInventory(List inventorySlots, ItemStack stackToShift, int numSlots) {
        boolean success = false;
        if (stackToShift.func_77985_e()) {
            success = SlotUtil.shiftToMachineInventory(inventorySlots, stackToShift, numSlots, true);
        }
        if (stackToShift.field_77994_a > 0) {
            success |= SlotUtil.shiftToMachineInventory(inventorySlots, stackToShift, numSlots, false);
        }
        return success;
    }

    private static boolean shiftToMachineInventory(List inventorySlots, ItemStack stackToShift, int numSlots, boolean mergeOnly) {
        for (int machineIndex = 36; machineIndex < numSlots; ++machineIndex) {
            SlotForestry slotForestry;
            Slot slot = (Slot)inventorySlots.get(machineIndex);
            if (mergeOnly && slot.func_75211_c() == null || slot instanceof SlotForestry && (!(slotForestry = (SlotForestry)slot).canShift() || slotForestry.isPhantom()) || !slot.func_75214_a(stackToShift) || !SlotUtil.shiftItemStackToRange(inventorySlots, stackToShift, machineIndex, 1)) continue;
            return true;
        }
        return false;
    }
}

