/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.api.core.ForestryAPI;
import forestry.core.tiles.TileEngine;
import forestry.energy.EnergyManager;
import forestry.energy.compat.rf.RFHelper;
import forestry.energy.compat.tesla.TeslaHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHelper {
    public static int scaleForDifficulty(int energyValue) {
        float energyModifier = ForestryAPI.activeMode.getFloatSetting("energy.demand.modifier");
        return Math.round((float)energyValue * energyModifier);
    }

    public static boolean consumeEnergyToDoWork(EnergyManager energyManager, int ticksPerWorkCycle, int energyPerWorkCycle) {
        if (energyPerWorkCycle == 0) {
            return true;
        }
        int energyPerCycle = (int)Math.ceil((float)energyPerWorkCycle / (float)ticksPerWorkCycle);
        if (energyManager.getEnergyStored() < energyPerCycle) {
            return false;
        }
        energyManager.drainEnergy(energyPerCycle);
        return true;
    }

    public static int sendEnergy(EnergyManager energyManager, EnumFacing orientation, TileEntity tile) {
        return EnergyHelper.sendEnergy(energyManager, orientation, tile, Integer.MAX_VALUE, false);
    }

    public static int sendEnergy(EnergyManager energyManager, EnumFacing orientation, TileEntity tile, int amount, boolean simulate) {
        int extractable;
        if (tile != null && (extractable = energyManager.extractEnergy(amount, true)) > 0) {
            int sent;
            EnumFacing side = orientation.func_176734_d();
            if (tile instanceof TileEngine) {
                TileEngine receptor = (TileEngine)tile;
                sent = receptor.getEnergyManager().receiveEnergy(extractable, simulate);
            } else if (tile.hasCapability(CapabilityEnergy.ENERGY, side)) {
                IEnergyStorage energyStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side);
                sent = energyStorage.receiveEnergy(extractable, simulate);
            } else {
                sent = TeslaHelper.isEnergyReceiver(tile, side) ? TeslaHelper.sendEnergy(tile, side, extractable, simulate) : (RFHelper.isEnergyReceiver(tile, side) ? RFHelper.sendEnergy(tile, side, extractable, simulate) : 0);
            }
            energyManager.extractEnergy(sent, simulate);
            return sent;
        }
        return 0;
    }

    public static boolean canSendEnergy(EnergyManager energyManager, EnumFacing orientation, TileEntity tile) {
        return EnergyHelper.sendEnergy(energyManager, orientation, tile, Integer.MAX_VALUE, true) > 0;
    }

    public static boolean isEnergyReceiverOrEngine(EnumFacing side, TileEntity tile) {
        if (tile != null) {
            if (tile instanceof TileEngine) {
                return true;
            }
            if (tile.hasCapability(CapabilityEnergy.ENERGY, side)) {
                IEnergyStorage energyStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side);
                return energyStorage.canReceive();
            }
            if (TeslaHelper.isEnergyReceiver(tile, side)) {
                return true;
            }
            if (RFHelper.isEnergyReceiver(tile, side)) {
                return true;
            }
        }
        return false;
    }
}

