/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import com.google.common.base.Preconditions;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.gui.ContainerWorktable;
import forestry.factory.gui.GuiWorktable;
import forestry.factory.inventory.InventoryCraftingForestry;
import forestry.factory.inventory.InventoryGhostCrafting;
import forestry.factory.inventory.InventoryWorktable;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.ICrafterWorktable;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileWorktable
extends TileBase
implements ICrafterWorktable {
    private RecipeMemory recipeMemory;
    private final InventoryAdapterTile craftingDisplay;
    private MemorizedRecipe currentRecipe;

    public TileWorktable() {
        super("worktable");
        this.setInternalInventory(new InventoryWorktable(this));
        this.craftingDisplay = new InventoryGhostCrafting<TileWorktable>(this, 10);
        this.recipeMemory = new RecipeMemory();
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.craftingDisplay.writeToNBT(nbttagcompound);
        this.recipeMemory.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.craftingDisplay.readFromNBT(nbttagcompound);
        this.recipeMemory = new RecipeMemory(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.craftingDisplay.writeData(data);
        this.recipeMemory.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.craftingDisplay.readData(data);
        this.recipeMemory.readData(data);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.recipeMemory.validate(this.field_145850_b);
    }

    public boolean hasRecipeConflict() {
        return this.currentRecipe != null && this.currentRecipe.hasRecipeConflict();
    }

    public void chooseNextConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.incrementRecipe();
        }
    }

    public void choosePreviousConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.decrementRecipe();
        }
    }

    @Override
    public boolean canTakeStack(int craftingSlotIndex) {
        if (craftingSlotIndex == 9) {
            return this.canCraftCurrentRecipe();
        }
        return true;
    }

    private boolean canCraftCurrentRecipe() {
        return this.craftRecipe(true);
    }

    @Override
    public boolean onCraftingStart(EntityPlayer player) {
        return this.craftRecipe(false);
    }

    private boolean craftRecipe(boolean simulate) {
        TileWorktable inventory;
        if (this.currentRecipe == null) {
            return false;
        }
        IRecipe selectedRecipe = this.currentRecipe.getSelectedRecipe();
        if (selectedRecipe == null) {
            return false;
        }
        ItemStack[] inventoryStacks = InventoryUtil.getStacks((IInventory)this);
        InventoryCraftingForestry crafting = RecipeUtil.getCraftRecipe(this.currentRecipe.getCraftMatrix(), inventoryStacks, this.field_145850_b, selectedRecipe);
        if (crafting == null) {
            return false;
        }
        ItemStack[] recipeItems = InventoryUtil.getStacks((IInventory)crafting);
        if (simulate) {
            inventory = new InventoryBasic("copy", false, this.func_70302_i_());
            InventoryUtil.deepCopyInventoryContents((IInventory)this, (IInventory)inventory);
        } else {
            inventory = this;
        }
        if (!InventoryUtil.deleteExactSet((IInventory)inventory, recipeItems)) {
            return false;
        }
        if (!simulate) {
            this.currentRecipe.setCraftMatrix(crafting);
            this.setCurrentRecipe(this.currentRecipe);
        }
        return true;
    }

    @Override
    public void onCraftingComplete(EntityPlayer player) {
        Preconditions.checkState((this.currentRecipe != null ? 1 : 0) != 0);
        IRecipe selectedRecipe = this.currentRecipe.getSelectedRecipe();
        Preconditions.checkState((selectedRecipe != null ? 1 : 0) != 0);
        ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        InventoryCraftingForestry craftMatrix = this.currentRecipe.getCraftMatrix();
        ItemStack[] remainingItems = selectedRecipe.func_179532_b((InventoryCrafting)craftMatrix.copy());
        ForgeHooks.setCraftingPlayer(null);
        for (ItemStack remainingItem : remainingItems) {
            if (remainingItem == null || InventoryUtil.tryAddStack((IInventory)this, remainingItem, true)) continue;
            player.func_71019_a(remainingItem, false);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.recipeMemory.memorizeRecipe(this.field_145850_b.func_82737_E(), this.currentRecipe);
        }
    }

    @Override
    @Nullable
    public ItemStack getResult(InventoryCrafting inventoryCrafting, World world) {
        if (this.currentRecipe != null) {
            return this.currentRecipe.getCraftingResult(inventoryCrafting, world);
        }
        return null;
    }

    public RecipeMemory getMemory() {
        return this.recipeMemory;
    }

    public void chooseRecipeMemory(int recipeIndex) {
        MemorizedRecipe recipe = this.recipeMemory.getRecipe(recipeIndex);
        this.setCurrentRecipe(recipe);
    }

    private void setCraftingDisplay(IInventory craftMatrix) {
        if (craftMatrix == null) {
            return;
        }
        for (int slot = 0; slot < craftMatrix.func_70302_i_(); ++slot) {
            this.craftingDisplay.func_70299_a(slot, craftMatrix.func_70301_a(slot));
        }
    }

    public IInventory getCraftingDisplay() {
        return new InventoryMapper((IInventory)this.craftingDisplay, 0, 9);
    }

    public void clearCraftMatrix() {
        for (int slot = 0; slot < this.craftingDisplay.func_70302_i_(); ++slot) {
            this.craftingDisplay.func_70299_a(slot, null);
        }
    }

    public void setCurrentRecipe(InventoryCraftingForestry crafting) {
        ItemStack[] currentStacks;
        ItemStack[] stacks;
        MemorizedRecipe recipe;
        List<IRecipe> recipes = RecipeUtil.findMatchingRecipes(crafting, this.field_145850_b);
        MemorizedRecipe memorizedRecipe = recipe = recipes.isEmpty() ? null : new MemorizedRecipe(crafting, recipes);
        if (this.currentRecipe != null && recipe != null && recipe.hasRecipe(this.currentRecipe.getSelectedRecipe()) && ItemStackUtil.equalSets(stacks = InventoryUtil.getStacks((IInventory)crafting), currentStacks = InventoryUtil.getStacks((IInventory)this.currentRecipe.getCraftMatrix()))) {
            return;
        }
        this.setCurrentRecipe(recipe);
    }

    public MemorizedRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(MemorizedRecipe recipe) {
        this.currentRecipe = recipe;
        if (this.currentRecipe != null) {
            this.setCraftingDisplay((IInventory)this.currentRecipe.getCraftMatrix());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGui(EntityPlayer player, int data) {
        return new GuiWorktable(player, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerWorktable(player, this);
    }
}

