/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import com.google.common.collect.ImmutableMap;
import forestry.api.climate.EnumClimatiserModes;
import forestry.api.climate.EnumClimatiserTypes;
import forestry.api.climate.IClimatiserDefinition;
import forestry.core.climate.ClimatiserDefinition;
import forestry.core.proxy.Proxies;
import forestry.greenhouse.multiblock.MultiblockLogicGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouseClimatiser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class TileGreenhouseSprinkler
extends TileGreenhouseClimatiser {
    private final IAnimationStateMachine asm;
    private final TimeValues.VariableValue cycleLength = new TimeValues.VariableValue(20.0f);
    private final TimeValues.VariableValue clickTime = new TimeValues.VariableValue(Float.NEGATIVE_INFINITY);
    protected static final int WATER_PER_OPERATION = 25;
    private static final IClimatiserDefinition DEFINITION = new ClimatiserDefinition(0.005f, EnumClimatiserModes.POSITIVE, 9.0, EnumClimatiserTypes.HUMIDITY);

    public TileGreenhouseSprinkler() {
        super(DEFINITION, 22);
        this.asm = Proxies.render.loadAnimationState(new ResourceLocation("forestry", "asms/block/sprinkler.json"), (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"cycle_length", (Object)this.cycleLength, (Object)"click_time", (Object)this.clickTime));
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public boolean canWork() {
        Object logic = this.getMultiblockLogic();
        if (logic == null || !logic.isConnected() || ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getTankManager() == null || ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getTankManager().getTank(0) == null) {
            return false;
        }
        return this.consumeWaterToDoWork(1, 25, ((MultiblockLogicGreenhouse)this.getMultiblockLogic()).getController().getTankManager().getTank(0));
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            if (this.asm.currentState().equals("moving") && !this.isActive()) {
                this.clickTime.setValue(Animation.getWorldTime((World)this.func_145831_w(), (float)Animation.getPartialTickTime()));
                this.asm.transition("stopping");
            } else if (this.asm.currentState().equals("default") && this.isActive()) {
                float time = Animation.getWorldTime((World)this.func_145831_w(), (float)Animation.getPartialTickTime());
                this.clickTime.setValue(time);
                this.asm.transition("starting");
            }
        }
    }

    public boolean consumeWaterToDoWork(int ticksPerWorkCycle, int fluidPerWorkCycle, IFluidTank tank) {
        int fluidPerCycle = (int)Math.ceil((float)fluidPerWorkCycle / (float)ticksPerWorkCycle);
        if (tank.getFluid() == null || tank.getFluid().amount < fluidPerCycle) {
            return false;
        }
        FluidStack drained = tank.drain(fluidPerCycle, true);
        return drained != null && drained.amount > 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(capability, side);
    }
}

