/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.util.CycleTimer;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class GuiIngredient<T>
extends Gui
implements IGuiIngredient<T> {
    private static final String oreDictionaryIngredient = Translator.translateToLocal("jei.tooltip.recipe.ore.dict");
    private final int slotIndex;
    private final boolean input;
    private final int xPosition;
    private final int yPosition;
    private final int width;
    private final int height;
    private final int xPadding;
    private final int yPadding;
    private final CycleTimer cycleTimer;
    private final List<T> displayIngredients = new ArrayList<T>();
    private final List<T> allIngredients = new ArrayList<T>();
    private final IIngredientRenderer<T> ingredientRenderer;
    private final IIngredientHelper<T> ingredientHelper;
    @Nullable
    private ITooltipCallback<T> tooltipCallback;
    private boolean enabled;

    public GuiIngredient(int slotIndex, boolean input, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper, int xPosition, int yPosition, int width, int height, int xPadding, int yPadding, int cycleOffset) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredientHelper = ingredientHelper;
        this.slotIndex = slotIndex;
        this.input = input;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.xPadding = xPadding;
        this.yPadding = yPadding;
        this.cycleTimer = new CycleTimer(cycleOffset);
    }

    public boolean isMouseOver(int xOffset, int yOffset, int mouseX, int mouseY) {
        return this.enabled && mouseX >= xOffset + this.xPosition && mouseY >= yOffset + this.yPosition && mouseX < xOffset + this.xPosition + this.width && mouseY < yOffset + this.yPosition + this.height;
    }

    @Override
    @Nullable
    @Deprecated
    public IFocus<T> getCurrentlyDisplayed() {
        T ingredient = this.getDisplayedIngredient();
        if (ingredient == null) {
            return null;
        }
        return new Focus<T>(ingredient);
    }

    @Override
    @Nullable
    public T getDisplayedIngredient() {
        return this.cycleTimer.getCycledItem(this.displayIngredients);
    }

    @Override
    public List<T> getAllIngredients() {
        return this.allIngredients;
    }

    public void set(T ingredient, IFocus<T> focus) {
        this.set(Collections.singletonList(ingredient), focus);
    }

    public void set(@Nullable List<T> ingredients, IFocus<T> focus) {
        this.displayIngredients.clear();
        this.allIngredients.clear();
        ingredients = ingredients == null ? Collections.emptyList() : this.ingredientHelper.expandSubtypes(ingredients);
        T match = this.getMatch(ingredients, focus);
        if (match != null) {
            this.displayIngredients.add(match);
        } else {
            this.displayIngredients.addAll(ingredients);
        }
        this.allIngredients.addAll(ingredients);
        this.enabled = !this.displayIngredients.isEmpty();
    }

    @Nullable
    private T getMatch(Collection<T> ingredients, IFocus<T> focus) {
        T focusValue;
        if ((this.isInput() && focus.getMode() == IFocus.Mode.INPUT || !this.isInput() && focus.getMode() == IFocus.Mode.OUTPUT) && (focusValue = focus.getValue()) != null) {
            return this.ingredientHelper.getMatch(ingredients, focusValue);
        }
        return null;
    }

    public void setTooltipCallback(@Nullable ITooltipCallback<T> tooltipCallback) {
        this.tooltipCallback = tooltipCallback;
    }

    public void draw(Minecraft minecraft, int xOffset, int yOffset) {
        this.cycleTimer.onDraw();
        T value = this.getDisplayedIngredient();
        this.ingredientRenderer.render(minecraft, xOffset + this.xPosition + this.xPadding, yOffset + this.yPosition + this.yPadding, value);
    }

    public void drawHovered(Minecraft minecraft, int xOffset, int yOffset, int mouseX, int mouseY) {
        this.draw(minecraft, xOffset, yOffset);
        T value = this.getDisplayedIngredient();
        if (value != null) {
            this.drawTooltip(minecraft, xOffset, yOffset, mouseX, mouseY, value);
        }
    }

    @Override
    public void drawHighlight(Minecraft minecraft, Color color, int xOffset, int yOffset) {
        int x = this.xPosition + xOffset + this.xPadding;
        int y = this.yPosition + yOffset + this.yPadding;
        GlStateManager.func_179140_f();
        GuiIngredient.func_73734_a((int)x, (int)y, (int)(x + this.width - this.xPadding * 2), (int)(y + this.height - this.yPadding * 2), (int)color.getRGB());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawTooltip(Minecraft minecraft, int xOffset, int yOffset, int mouseX, int mouseY, T value) {
        try {
            GlStateManager.func_179097_i();
            RenderHelper.func_74518_a();
            GuiIngredient.func_73734_a((int)(xOffset + this.xPosition + this.xPadding), (int)(yOffset + this.yPosition + this.yPadding), (int)(xOffset + this.xPosition + this.width - this.xPadding), (int)(yOffset + this.yPosition + this.height - this.yPadding), (int)Integer.MAX_VALUE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            List<String> tooltip = this.ingredientRenderer.getTooltip(minecraft, value);
            tooltip = Internal.getModIdUtil().addModNameToIngredientTooltip(tooltip, value, this.ingredientHelper);
            if (this.tooltipCallback != null) {
                this.tooltipCallback.onTooltip(this.slotIndex, this.input, value, tooltip);
            }
            FontRenderer fontRenderer = this.ingredientRenderer.getFontRenderer(minecraft, value);
            if (value instanceof ItemStack) {
                List<ItemStack> itemStacks = this.allIngredients;
                String oreDictEquivalent = Internal.getStackHelper().getOreDictEquivalent(itemStacks);
                if (oreDictEquivalent != null) {
                    String acceptsAny = String.format(oreDictionaryIngredient, oreDictEquivalent);
                    tooltip.add(TextFormatting.GRAY + acceptsAny);
                }
                TooltipRenderer.drawHoveringText((ItemStack)value, minecraft, tooltip, xOffset + mouseX, yOffset + mouseY, fontRenderer);
            } else {
                TooltipRenderer.drawHoveringText(minecraft, tooltip, xOffset + mouseX, yOffset + mouseY, fontRenderer);
            }
            GlStateManager.func_179126_j();
        }
        catch (RuntimeException e) {
            Log.error("Exception when rendering tooltip on {}.", value, e);
        }
    }

    @Override
    public boolean isInput() {
        return this.input;
    }
}

