/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.util.BrokenCraftingRecipeException;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;

public class ShapedRecipesWrapper
extends BlankRecipeWrapper
implements IShapedCraftingRecipeWrapper {
    private final ShapedRecipes recipe;

    public ShapedRecipesWrapper(ShapedRecipes recipe) {
        this.recipe = recipe;
        for (ItemStack itemStack : this.recipe.field_77574_d) {
            if (itemStack == null || itemStack.field_77994_a == 1) continue;
            itemStack.field_77994_a = 1;
        }
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        List<ItemStack> recipeItems = Arrays.asList(this.recipe.field_77574_d);
        ItemStack recipeOutput = this.recipe.func_77571_b();
        try {
            ingredients.setInputs(ItemStack.class, recipeItems);
            if (recipeOutput != null) {
                ingredients.setOutput(ItemStack.class, recipeOutput);
            }
        }
        catch (RuntimeException e) {
            String info = ErrorUtil.getInfoFromBrokenCraftingRecipe(this.recipe, recipeItems, recipeOutput);
            throw new BrokenCraftingRecipeException(info, e);
        }
    }

    @Override
    public List getInputs() {
        return Arrays.asList(this.recipe.field_77574_d);
    }

    @Override
    public List<ItemStack> getOutputs() {
        return Collections.singletonList(this.recipe.func_77571_b());
    }

    @Override
    public int getWidth() {
        return this.recipe.field_77576_b;
    }

    @Override
    public int getHeight() {
        return this.recipe.field_77577_c;
    }
}

