/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.base.Optional;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import javax.annotation.Nullable;

public class ReflectionUtil {
    private static Table<Class, Class, Optional<Field>> cache = HashBasedTable.create();

    @Nullable
    public static <T> T getFieldWithClass(Object object, Class<T> fieldClass) {
        Field field = ReflectionUtil.getField(object, fieldClass);
        if (field != null) {
            try {
                Object fieldValue = field.get(object);
                if (fieldClass.isInstance(fieldValue)) {
                    return fieldClass.cast(fieldValue);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static Field getField(Object object, Class<?> fieldClass) {
        Class<?> objectClass = object.getClass();
        Optional cachedField = (Optional)cache.get(fieldClass, objectClass);
        if (cachedField != null) {
            if (cachedField.isPresent()) {
                return (Field)cachedField.get();
            }
            return null;
        }
        try {
            Field[] fields;
            for (Field field : fields = objectClass.getDeclaredFields()) {
                if (!fieldClass.isAssignableFrom(field.getType())) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                cache.put(fieldClass, objectClass, (Object)Optional.of((Object)field));
                return field;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        cache.put(fieldClass, objectClass, (Object)Optional.absent());
        return null;
    }
}

