/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine;

import ic2.api.recipe.ICannerBottleRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class CannerBottleRecipeManager
implements ICannerBottleRecipeManager {
    private final Map<ICannerBottleRecipeManager.Input, RecipeOutput> recipes = new HashMap<ICannerBottleRecipeManager.Input, RecipeOutput>();

    @Override
    public void addRecipe(IRecipeInput container, IRecipeInput fill, ItemStack output) {
        if (container == null) {
            throw new NullPointerException("The container recipe input is null");
        }
        if (fill == null) {
            throw new NullPointerException("The fill recipe input is null");
        }
        if (StackUtil.isEmpty(output)) {
            throw new IllegalArgumentException("The recipe output " + StackUtil.toStringSafe(output) + " is invalid");
        }
        for (ICannerBottleRecipeManager.Input input : this.recipes.keySet()) {
            for (ItemStack containerStack : container.getInputs()) {
                for (ItemStack fillStack : fill.getInputs()) {
                    if (!input.matches(containerStack, fillStack)) continue;
                    throw new RuntimeException("ambiguous recipe: [" + container.getInputs() + "+" + fill.getInputs() + " -> " + output + "], conflicts with [" + input.container.getInputs() + "+" + input.fill.getInputs() + " -> " + this.recipes.get(input) + "]");
                }
            }
        }
        this.recipes.put(new ICannerBottleRecipeManager.Input(container, fill), new RecipeOutput(null, output));
    }

    @Override
    public RecipeOutput getOutputFor(ItemStack container, ItemStack fill, boolean adjustInput, boolean acceptTest) {
        if (acceptTest ? StackUtil.isEmpty(container) && StackUtil.isEmpty(fill) : StackUtil.isEmpty(container) || StackUtil.isEmpty(fill)) {
            return null;
        }
        for (Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput> entry : this.recipes.entrySet()) {
            ICannerBottleRecipeManager.Input recipeInput = entry.getKey();
            if (acceptTest && StackUtil.isEmpty(container)) {
                if (!recipeInput.fill.matches(fill)) continue;
                return entry.getValue();
            }
            if (acceptTest && StackUtil.isEmpty(fill)) {
                if (!recipeInput.container.matches(container)) continue;
                return entry.getValue();
            }
            if (!recipeInput.matches(container, fill)) continue;
            if (!acceptTest && (StackUtil.isEmpty(container) || StackUtil.getSize(container) < recipeInput.container.getAmount() || StackUtil.getSize(fill) < recipeInput.fill.getAmount())) break;
            if (adjustInput) {
                if (!StackUtil.isEmpty(container)) {
                    container.field_77994_a -= recipeInput.container.getAmount();
                }
                fill.field_77994_a -= recipeInput.fill.getAmount();
            }
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Map<ICannerBottleRecipeManager.Input, RecipeOutput> getRecipes() {
        return this.recipes;
    }
}

