/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.item.tool.ItemElectricTool;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

public class AnvilFixer {
    public static boolean needsFixing(ItemStack tool, ItemStack book) {
        Item toolItem = tool.func_77973_b();
        return (toolItem instanceof ItemElectricTool || toolItem instanceof ItemArmorElectric) && !toolItem.isBookEnchantable(tool, book);
    }

    @SubscribeEvent
    public void onAnvilCalculate(AnvilUpdateEvent event) {
        ItemStack tool = event.getLeft();
        if (tool != null && AnvilFixer.needsFixing(tool, event.getRight())) {
            String newName = event.getName();
            ItemStack output = tool.func_77946_l();
            boolean madeChange = false;
            if (StringUtils.isBlank((CharSequence)newName)) {
                if (tool.func_82837_s()) {
                    madeChange = true;
                    output.func_135074_t();
                }
            } else if (!newName.equals(tool.func_82833_r())) {
                madeChange = true;
                output.func_151001_c(newName);
            }
            if (madeChange) {
                event.setOutput(output);
                event.setCost(1);
                event.setMaterialCost(1);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onAnvilUse(AnvilRepairEvent event) {
        ItemStack tool = event.getItemInput();
        ItemStack book = event.getIngredientInput();
        if (tool != null && book != null && AnvilFixer.needsFixing(tool, book)) {
            ++book.field_77994_a;
        }
    }
}

