/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.core.item.ItemIC2FluidContainer;
import ic2.core.ref.ItemName;
import ic2.core.util.LiquidUtil;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidCell
extends ItemIC2FluidContainer {
    public ItemFluidCell() {
        super(ItemName.fluid_cell, 1000);
    }

    public boolean isRepairable() {
        return false;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (this.interactWithTank(player, hand, world, pos, side)) {
            player.field_71069_bz.func_75142_b();
            return EnumActionResult.SUCCESS;
        }
        RayTraceResult position = this.func_77621_a(world, player, true);
        if (position == null) {
            return EnumActionResult.FAIL;
        }
        if (position.field_72313_a == RayTraceResult.Type.BLOCK) {
            pos = position.func_178782_a();
            if (!world.canMineBlockBody(player, pos)) {
                return EnumActionResult.FAIL;
            }
            if (!player.func_175151_a(pos, position.field_178784_b, stack)) {
                return EnumActionResult.FAIL;
            }
            if (LiquidUtil.drainBlockToContainer(world, pos, player, hand) || LiquidUtil.fillBlockFromContainer(world, pos, player, hand) || LiquidUtil.fillBlockFromContainer(world, pos.func_177972_a(side), player, hand)) {
                player.field_71069_bz.func_75142_b();
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack emptyStack = new ItemStack(item);
        subItems.add(emptyStack);
        for (Fluid fluid : LiquidUtil.getAllFluids()) {
            ItemStack stack;
            if (fluid == null || this.fill(stack = emptyStack.func_77946_l(), new FluidStack(fluid, Integer.MAX_VALUE), true) <= 0) continue;
            subItems.add(stack);
        }
    }

    private boolean interactWithTank(EntityPlayer player, EnumHand hand, World world, BlockPos pos, EnumFacing side) {
        assert (!world.field_72995_K);
        TileEntity te = world.func_175625_s(pos);
        if (!LiquidUtil.isFluidTile(te, side)) {
            return false;
        }
        ItemStack stack = StackUtil.get(player, hand);
        FluidStack fs = this.getFluid(stack);
        if (fs == null || player.func_70093_af() && fs.amount < this.capacity) {
            int amount = fs == null ? this.capacity : this.capacity - fs.amount;
            FluidStack input = LiquidUtil.drainTile(te, side, amount, true);
            if (input == null || input.amount <= 0) {
                return true;
            }
            amount = LiquidUtil.fillContainer(player, hand, input, LiquidUtil.FluidContainerOutputMode.InPlacePreferred, false);
            if (amount > 0) {
                LiquidUtil.drainTile(te, side, amount, false);
            }
            return true;
        }
        int amount = LiquidUtil.fillTile(te, side, fs, true);
        if (amount <= 0) {
            return true;
        }
        fs = LiquidUtil.drainContainer(player, hand, null, amount, LiquidUtil.FluidContainerOutputMode.InPlacePreferred, false);
        if (fs != null) {
            LiquidUtil.fillTile(te, side, fs, false);
        }
        return true;
    }
}

