/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.recipe;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.core.util.StackUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BasicMachineRecipeManagerTest
implements IMachineRecipeManager {
    private final List<IMachineRecipeManager.RecipeIoContainer> recipes = new LinkedList<IMachineRecipeManager.RecipeIoContainer>();

    @Override
    public boolean addRecipe(IRecipeInput input, NBTTagCompound metadata, boolean replace, ItemStack ... outputs) {
        if (replace) {
            this.recipes.add(0, new IMachineRecipeManager.RecipeIoContainer(input, new RecipeOutput(metadata, outputs)));
        } else if (this.getCollidingRecipe(input) == null) {
            this.recipes.add(new IMachineRecipeManager.RecipeIoContainer(input, new RecipeOutput(metadata, outputs)));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public RecipeOutput getOutputFor(ItemStack input, boolean adjustInput) {
        IMachineRecipeManager.RecipeIoContainer recipe = this.getRecipe(input, true);
        if (recipe == null) {
            return null;
        }
        if (adjustInput) {
            if (input.func_77973_b().hasContainerItem(input)) {
                ItemStack container = input.func_77973_b().getContainerItem(input);
                input.func_150996_a(container.func_77973_b());
                input.func_77964_b(container.func_77952_i());
                input.field_77994_a = StackUtil.getSize(container);
                input.func_77982_d(container.func_77978_p());
            } else {
                input.field_77994_a -= recipe.input.getAmount();
            }
        }
        return recipe.output;
    }

    private IMachineRecipeManager.RecipeIoContainer getCollidingRecipe(IRecipeInput input) {
        for (ItemStack itemStackIn : input.getInputs()) {
            IMachineRecipeManager.RecipeIoContainer recipe = this.getRecipe(itemStackIn, false);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    private IMachineRecipeManager.RecipeIoContainer getRecipe(ItemStack stack, boolean checkAmount) {
        for (IMachineRecipeManager.RecipeIoContainer container : this.recipes) {
            if (!container.input.matches(stack)) continue;
            if (!checkAmount) {
                return container;
            }
            if (StackUtil.getSize(stack) < container.input.getAmount() || stack.func_77973_b().hasContainerItem(stack) && StackUtil.getSize(stack) != container.input.getAmount()) continue;
            return container;
        }
        return null;
    }

    @Override
    public Iterable<IMachineRecipeManager.RecipeIoContainer> getRecipes() {
        return this.recipes;
    }

    @Override
    public boolean isIterable() {
        return true;
    }
}

