/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.uu;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.core.IC2;
import ic2.core.util.LogCategory;
import ic2.core.uu.IRecipeResolver;
import ic2.core.uu.LeanItemStack;
import ic2.core.uu.RecipeTransformation;
import ic2.core.uu.RecipeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MachineRecipeResolver
implements IRecipeResolver {
    private static final double transformCost = 14.0;
    private final IMachineRecipeManager manager;

    public MachineRecipeResolver(IMachineRecipeManager manager) {
        this.manager = manager;
    }

    @Override
    public List<RecipeTransformation> getTransformations() {
        if (!this.manager.isIterable()) {
            return Collections.emptyList();
        }
        ArrayList<RecipeTransformation> ret = new ArrayList<RecipeTransformation>();
        for (IMachineRecipeManager.RecipeIoContainer entry : this.manager.getRecipes()) {
            try {
                List<List<LeanItemStack>> inputs = RecipeUtil.convertIngredients(entry.input.getInputs());
                List<LeanItemStack> outputs = RecipeUtil.convertOutputs(entry.output.items);
                ret.add(new RecipeTransformation(14.0, inputs, outputs));
            }
            catch (IllegalArgumentException e) {
                IC2.log.warn(LogCategory.Uu, e, "invalid recipe");
            }
        }
        return ret;
    }
}

