/*
 * Decompiled with CFR 0.152.
 */
package cofh.api.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ThermalExpansionHelper {
    private ThermalExpansionHelper() {
    }

    public static void addFurnaceRecipe(int energy, ItemStack input, ItemStack output) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.func_77955_b(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"AddFurnaceRecipe", (NBTTagCompound)toSend);
    }

    public static void removeFurnaceRecipe(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"RemoveFurnaceRecipe", (NBTTagCompound)toSend);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        ThermalExpansionHelper.addPulverizerRecipe(energy, input, primaryOutput, null, 0);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addPulverizerRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input == null || primaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (secondaryOutput != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            toSend.func_74768_a("secondaryChance", secondaryChance);
        }
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"AddPulverizerRecipe", (NBTTagCompound)toSend);
    }

    public static void removePulverizerRecipe(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"RemovePulverizerRecipe", (NBTTagCompound)toSend);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
        ThermalExpansionHelper.addSawmillRecipe(energy, input, primaryOutput, null, 0);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addSawmillRecipe(energy, input, primaryOutput, secondaryOutput, 100);
    }

    public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (input == null || primaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (secondaryOutput != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            toSend.func_74768_a("secondaryChance", secondaryChance);
        }
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"AddSawmillRecipe", (NBTTagCompound)toSend);
    }

    public static void removeSawmillRecipe(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"RemoveSawmillRecipe", (NBTTagCompound)toSend);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        ThermalExpansionHelper.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput == null || secondaryInput == null || primaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l("primaryInput"));
        secondaryInput.func_77955_b(toSend.func_74775_l("secondaryInput"));
        primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (secondaryOutput != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            toSend.func_74768_a("secondaryChance", secondaryChance);
        }
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"AddSmelterRecipe", (NBTTagCompound)toSend);
    }

    public static void removeSmelterRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput == null || secondaryInput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l("primaryInput"));
        secondaryInput.func_77955_b(toSend.func_74775_l("secondaryInput"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"RemoveSmelterRecipe", (NBTTagCompound)toSend);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        ThermalExpansionHelper.addInsolatorRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        ThermalExpansionHelper.addInsolatorRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static void addInsolatorRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput == null || secondaryInput == null || primaryOutput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("primaryOutput", (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l("primaryInput"));
        secondaryInput.func_77955_b(toSend.func_74775_l("secondaryInput"));
        primaryOutput.func_77955_b(toSend.func_74775_l("primaryOutput"));
        if (secondaryOutput != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
            secondaryOutput.func_77955_b(toSend.func_74775_l("secondaryOutput"));
            toSend.func_74768_a("secondaryChance", secondaryChance);
        }
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"AddInsolatorRecipe", (NBTTagCompound)toSend);
    }

    public static void removeInsolatorRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput == null || secondaryInput == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("primaryInput", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("secondaryInput", (NBTBase)new NBTTagCompound());
        primaryInput.func_77955_b(toSend.func_74775_l("primaryInput"));
        secondaryInput.func_77955_b(toSend.func_74775_l("secondaryInput"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"RemoveInsolatorRecipe", (NBTTagCompound)toSend);
    }

    public static void addCrucibleRecipe(int energy, ItemStack input, FluidStack output) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.writeToNBT(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"AddCrucibleRecipe", (NBTTagCompound)toSend);
    }

    public static void removeCrucibleRecipe(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"RemoveCrucibleRecipe", (NBTTagCompound)toSend);
    }

    public static void addRefineryRecipe(int energy, FluidStack input, FluidStack output, ItemStack outputItem) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        if (outputItem != null) {
            toSend.func_74782_a("secondaryOutput", (NBTBase)new NBTTagCompound());
            outputItem.func_77955_b(toSend.func_74775_l("secondaryOutput"));
        }
        input.writeToNBT(toSend.func_74775_l("input"));
        output.writeToNBT(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"AddRefineryRecipe", (NBTTagCompound)toSend);
    }

    public static void removeRefineryRecipe(FluidStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.writeToNBT(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"RemoveRefineryRecipe", (NBTTagCompound)toSend);
    }

    public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (input == null || output == null || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.func_77955_b(toSend.func_74775_l("output"));
        toSend.func_74757_a("reversible", reversible);
        fluid.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"AddTransposerFillRecipe", (NBTTagCompound)toSend);
    }

    public static void addTransposerExtract(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        if (input == null || output == null || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.func_77955_b(toSend.func_74775_l("output"));
        toSend.func_74757_a("reversible", reversible);
        toSend.func_74768_a("chance", chance);
        fluid.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"AddTransposerExtractRecipe", (NBTTagCompound)toSend);
    }

    public static void removeTransposerFill(ItemStack input, FluidStack fluid) {
        if (input == null || fluid == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("fluid", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        fluid.writeToNBT(toSend.func_74775_l("fluid"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"RemoveTransposerFillRecipe", (NBTTagCompound)toSend);
    }

    public static void removeTransposerExtract(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"RemoveTransposerExtractRecipe", (NBTTagCompound)toSend);
    }

    public static void addChargerRecipe(int energy, ItemStack input, ItemStack output) {
        if (input == null || output == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74768_a("energy", energy);
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        toSend.func_74782_a("output", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        output.func_77955_b(toSend.func_74775_l("output"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"AddChargerRecipe", (NBTTagCompound)toSend);
    }

    public static void removeChargerRecipe(ItemStack input) {
        if (input == null) {
            return;
        }
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74782_a("input", (NBTBase)new NBTTagCompound());
        input.func_77955_b(toSend.func_74775_l("input"));
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"RemoveChargerRecipe", (NBTTagCompound)toSend);
    }

    public static void addMagmaticFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", fluidName);
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"MagmaticFuel", (NBTTagCompound)toSend);
    }

    public static void addCompressionFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", fluidName);
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"CompressionFuel", (NBTTagCompound)toSend);
    }

    public static void addReactantFuel(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", fluidName);
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"ReactantFuel", (NBTTagCompound)toSend);
    }

    public static void addCoolant(String fluidName, int energy) {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.func_74778_a("fluidName", fluidName);
        toSend.func_74768_a("energy", energy);
        FMLInterModComms.sendMessage((String)"thermalexpansion", (String)"Coolant", (NBTTagCompound)toSend);
    }
}

