/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public final class CodeHelper {
    public static String getModIdFromActiveModContainer() {
        String modId;
        ModContainer mc = Loader.instance().activeModContainer();
        String string = modId = null != mc ? mc.getModId() : null;
        if (null == modId || modId.isEmpty()) {
            throw new RuntimeException("Cannot retrieve the MOD ID from FML");
        }
        return modId;
    }

    public static String i18nValue(boolean value) {
        return I18n.func_135052_a((String)(value ? "debug.zerocore.true" : "debug.zerocore.false"), (Object[])new Object[0]);
    }

    public static void sendChatMessage(@Nonnull ICommandSender sender, @Nonnull ITextComponent component) {
        if (sender instanceof EntityPlayer) {
            ((EntityPlayer)sender).func_145747_a(component);
        } else {
            sender.func_145747_a(component);
        }
    }

    public static boolean runningInDevEnv() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static NBTTagCompound nbtLoadFrom(File file) {
        if (null == file) {
            throw new IllegalArgumentException("The file to read from cannot be null");
        }
        if (!file.exists()) return null;
        try (FileInputStream stream = new FileInputStream(file);){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
            return nBTTagCompound;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static boolean nbtSaveTo(File file, NBTTagCompound data) {
        if (null == file) {
            throw new IllegalArgumentException("The file to write to cannot be null");
        }
        if (null == data) {
            throw new IllegalArgumentException("The data to write cannot be null");
        }
        try (FileOutputStream stream = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)stream);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

