/*
 * Decompiled with CFR 0.152.
 */
package cofh.asm;

import cofh.asm.relauncher.Implementable;
import cofh.asm.relauncher.Strippable;
import cofh.asm.relauncher.Substitutable;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMCore {
    static Logger log = LogManager.getLogger((String)"CoFH ASM");
    static THashSet<String> parsables;
    static THashSet<String> implementables;
    static THashSet<String> strippables;
    static THashSet<String> substitutables;
    static final String implementableDesc;
    static final String strippableDesc;
    static final String substitutableDesc;
    static String side;
    static final ArrayList<String> workingPath;
    private static final String[] emptyList;
    private static Map<String, ModContainer> mods;
    private static Map<String, ModContainer> apis;

    static void init() {
    }

    static byte[] parse(String name, String transformedName, byte[] bytes) {
        ClassWriter cw;
        ClassNode cn;
        ClassReader cr;
        workingPath.add(transformedName);
        if (implementables.contains((Object)name)) {
            log.debug("Adding runtime interfaces to " + transformedName);
            cr = new ClassReader(bytes);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (ASMCore.implement(cn)) {
                cw = new ClassWriter(0);
                cn.accept((ClassVisitor)cw);
                bytes = cw.toByteArray();
            } else {
                log.debug("Nothing implemented on " + transformedName);
            }
        }
        if (substitutables.contains((Object)name)) {
            log.debug("Substituting methods from " + transformedName);
            cr = new ClassReader(bytes);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (ASMCore.substitute(cn)) {
                cw = new ClassWriter(0);
                cn.accept((ClassVisitor)cw);
                bytes = cw.toByteArray();
            } else {
                log.debug("Nothing substituted from " + transformedName);
            }
        }
        if (strippables.contains((Object)name)) {
            log.debug("Stripping methods and fields from " + transformedName);
            cr = new ClassReader(bytes);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (ASMCore.strip(cn)) {
                cw = new ClassWriter(0);
                cn.accept((ClassVisitor)cw);
                bytes = cw.toByteArray();
            } else {
                log.debug("Nothing stripped from " + transformedName);
            }
        }
        workingPath.remove(workingPath.size() - 1);
        return bytes;
    }

    static boolean implement(ClassNode cn) {
        if (cn.visibleAnnotations == null) {
            return false;
        }
        boolean interfaces = false;
        for (AnnotationNode n : cn.visibleAnnotations) {
            AnnotationInfo node = ASMCore.parseAnnotation(n, implementableDesc);
            if (node == null || node.side != "NONE" && side != node.side) continue;
            String[] value = node.values;
            int l = value.length;
            for (int j = 0; j < l; ++j) {
                String clazz = value[j].trim();
                String cz = clazz.replace('.', '/');
                if (cn.interfaces.contains(cz)) continue;
                try {
                    if (!workingPath.contains(clazz)) {
                        Class.forName(clazz, false, ASMCore.class.getClassLoader());
                    }
                    cn.interfaces.add(cz);
                    interfaces = true;
                    continue;
                }
                catch (Throwable $) {
                    // empty catch block
                }
            }
        }
        return interfaces;
    }

    static boolean substitute(ClassNode cn) {
        boolean altered = false;
        if (cn.methods != null) {
            for (MethodNode mn : cn.methods) {
                if (mn.visibleAnnotations == null) continue;
                block13: for (AnnotationNode node : mn.visibleAnnotations) {
                    AnnotationInfo info = ASMCore.parseAnnotation(node, substitutableDesc);
                    if (!ASMCore.checkSub(info, mn)) continue;
                    altered = true;
                    mn.instructions.clear();
                    mn.localVariables = null;
                    for (MethodNode m : cn.methods) {
                        if (!info.method.equals(m.name) || !mn.desc.equals(m.desc)) continue;
                        mn.instructions.add(ASMCore.cloneList(m.instructions));
                        continue block13;
                    }
                    Type rType = Type.getReturnType((String)mn.desc);
                    switch (rType.getSort()) {
                        case 9: 
                        case 10: 
                        case 11: {
                            mn.instructions.add((AbstractInsnNode)new InsnNode(1));
                            break;
                        }
                        case 6: {
                            mn.instructions.add((AbstractInsnNode)new InsnNode(11));
                            break;
                        }
                        case 8: {
                            mn.instructions.add((AbstractInsnNode)new InsnNode(14));
                            break;
                        }
                        case 7: {
                            mn.instructions.add((AbstractInsnNode)new InsnNode(9));
                            break;
                        }
                        default: {
                            mn.instructions.add((AbstractInsnNode)new InsnNode(3));
                            switch (rType.getSort()) {
                                case 4: {
                                    mn.instructions.add((AbstractInsnNode)new InsnNode(147));
                                    break;
                                }
                                case 2: {
                                    mn.instructions.add((AbstractInsnNode)new InsnNode(146));
                                    break;
                                }
                                case 3: {
                                    mn.instructions.add((AbstractInsnNode)new InsnNode(145));
                                }
                            }
                        }
                        case 0: 
                    }
                    mn.instructions.add((AbstractInsnNode)new InsnNode(rType.getOpcode(172)));
                }
            }
        }
        return altered;
    }

    static boolean checkSub(AnnotationInfo node, MethodNode method) {
        if (node != null) {
            boolean needsReplaced;
            boolean bl = needsReplaced = node.side == side;
            if (!needsReplaced) {
                String[] value = node.values;
                int l = value.length;
                for (int j = 0; j < l && !(needsReplaced = ASMCore.parseValue(value[j])); ++j) {
                }
            }
            if (needsReplaced) {
                return !node.method.equals(method.name);
            }
        }
        return false;
    }

    static boolean strip(ClassNode cn) {
        Iterator iter;
        boolean altered = false;
        if (cn.visibleAnnotations != null) {
            for (AnnotationNode n : cn.visibleAnnotations) {
                AnnotationInfo node = ASMCore.parseAnnotation(n, strippableDesc);
                if (node == null) continue;
                String[] value = node.values;
                boolean wrongSide = side == node.side;
                for (String clazz : value) {
                    String cz = clazz.replace('.', '/');
                    if (!cn.interfaces.contains(cz)) continue;
                    boolean remove = true;
                    try {
                        if (!wrongSide && !workingPath.contains(clazz)) {
                            Class.forName(clazz, false, ASMCore.class.getClassLoader());
                            remove = false;
                        }
                    }
                    catch (Throwable $) {
                        // empty catch block
                    }
                    if (!remove) continue;
                    cn.interfaces.remove(cz);
                    altered = true;
                }
            }
        }
        if (cn.methods != null) {
            iter = cn.methods.iterator();
            block4: while (iter.hasNext()) {
                MethodNode mn = (MethodNode)iter.next();
                if (mn.visibleAnnotations == null) continue;
                for (AnnotationNode node : mn.visibleAnnotations) {
                    if (!ASMCore.checkRemove(ASMCore.parseAnnotation(node, strippableDesc), iter)) continue;
                    altered = true;
                    continue block4;
                }
            }
        }
        if (cn.fields != null) {
            iter = cn.fields.iterator();
            block6: while (iter.hasNext()) {
                FieldNode fn = (FieldNode)iter.next();
                if (fn.visibleAnnotations == null) continue;
                for (AnnotationNode node : fn.visibleAnnotations) {
                    if (!ASMCore.checkRemove(ASMCore.parseAnnotation(node, strippableDesc), iter)) continue;
                    altered = true;
                    continue block6;
                }
            }
        }
        return altered;
    }

    static boolean checkRemove(AnnotationInfo node, Iterator<? extends Object> iter) {
        if (node != null) {
            boolean needsRemoved;
            boolean bl = needsRemoved = node.side == side;
            if (!needsRemoved) {
                String[] value = node.values;
                int l = value.length;
                for (int j = 0; j < l && !(needsRemoved = ASMCore.parseValue(value[j])); ++j) {
                }
            }
            if (needsRemoved) {
                iter.remove();
                return true;
            }
        }
        return false;
    }

    static boolean parseValue(String clazz) {
        String mod;
        boolean ret = false;
        String string = mod = clazz.length() > 4 ? clazz.substring(4) : clazz;
        if (clazz.startsWith("mod:")) {
            int i = mod.indexOf(64);
            if (i > 0) {
                clazz = mod.substring(i + 1);
                mod = mod.substring(0, i);
            }
            boolean bl = ret = !Loader.isModLoaded((String)mod);
            if (!ret && i > 0) {
                ModContainer modc = ASMCore.getLoadedMods().get(mod);
                try {
                    if (!Boolean.parseBoolean((String)modc.getCustomModProperties().get("cofhversion"))) {
                        ret = !VersionRange.createFromVersionSpec((String)clazz).containsVersion(modc.getProcessedVersion());
                    }
                }
                catch (InvalidVersionSpecificationException e) {
                    ret = true;
                }
            }
        } else if (clazz.startsWith("api:")) {
            int i = mod.indexOf(64);
            if (i > 0) {
                clazz = mod.substring(i + 1);
                mod = mod.substring(0, i);
            }
            boolean bl = ret = !ModAPIManager.INSTANCE.hasAPI(mod);
            if (!ret && i > 0) {
                ModContainer modc = ASMCore.getLoadedAPIs().get(mod);
                try {
                    ret = !VersionRange.createFromVersionSpec((String)clazz).containsVersion(modc.getProcessedVersion());
                }
                catch (InvalidVersionSpecificationException e) {
                    ret = true;
                }
            }
        } else {
            try {
                if (!workingPath.contains(clazz)) {
                    Class.forName(clazz, false, ASMCore.class.getClassLoader());
                }
            }
            catch (Throwable $) {
                ret = true;
            }
        }
        return ret;
    }

    private static InsnList cloneList(InsnList list) {
        ListIterator iter = list.iterator();
        IdentityHashMap<LabelNode, LabelNode> some_form_of_bullshit_map = new IdentityHashMap<LabelNode, LabelNode>();
        IdentityHashMap<Label, Label> backing_bullshit = new IdentityHashMap<Label, Label>();
        while (iter.hasNext()) {
            AbstractInsnNode n = (AbstractInsnNode)iter.next();
            if (!(n instanceof LabelNode)) continue;
            LabelNode node = (LabelNode)n;
            Label label = (Label)backing_bullshit.get(node.getLabel());
            if (label == null) {
                label = new Label();
                backing_bullshit.put(node.getLabel(), label);
            }
            some_form_of_bullshit_map.put(node, new LabelNode(label));
        }
        InsnList ret = new InsnList();
        iter = list.iterator();
        while (iter.hasNext()) {
            ret.add(((AbstractInsnNode)iter.next()).clone(some_form_of_bullshit_map));
        }
        return ret;
    }

    static Map<String, ModContainer> getLoadedMods() {
        if (mods == null) {
            mods = new HashMap<String, ModContainer>();
            for (ModContainer m : Loader.instance().getModList()) {
                mods.put(m.getModId(), m);
            }
        }
        return mods;
    }

    public static Map<String, ModContainer> getLoadedAPIs() {
        if (apis == null) {
            apis = new HashMap<String, ModContainer>();
            for (ModContainer m : ModAPIManager.INSTANCE.getAPIList()) {
                apis.put(m.getModId(), m);
            }
        }
        return apis;
    }

    static AnnotationInfo parseAnnotation(AnnotationNode node, String desc) {
        AnnotationInfo info = null;
        if (node.desc.equals(desc)) {
            info = new AnnotationInfo();
            if (node.values != null) {
                List values = node.values;
                int i = 0;
                int e = values.size();
                while (i < e) {
                    Object k = values.get(i++);
                    Object v = values.get(i++);
                    if ("value".equals(k)) {
                        if (!(v instanceof List) || ((List)v).size() <= 0 || !(((List)v).get(0) instanceof String)) continue;
                        info.values = ((List)v).toArray(emptyList);
                        continue;
                    }
                    if ("side".equals(k) && v instanceof String) {
                        info.side = ((String)v).toUpperCase().intern();
                        continue;
                    }
                    if (!"method".equals(k) || !(v instanceof String)) continue;
                    info.method = (String)v;
                }
            }
        }
        return info;
    }

    static void scrapeData(ASMDataTable table) {
        String name;
        log.debug("Scraping data");
        side = FMLCommonHandler.instance().getSide().toString().toUpperCase(Locale.US).intern();
        for (ASMDataTable.ASMData data : table.getAll(Implementable.class.getName())) {
            name = data.getClassName();
            parsables.add((Object)name);
            parsables.add((Object)(name + "$class"));
            implementables.add((Object)name);
            implementables.add((Object)(name + "$class"));
        }
        for (ASMDataTable.ASMData data : table.getAll(Strippable.class.getName())) {
            name = data.getClassName();
            parsables.add((Object)name);
            parsables.add((Object)(name + "$class"));
            strippables.add((Object)name);
            strippables.add((Object)(name + "$class"));
        }
        for (ASMDataTable.ASMData data : table.getAll(Substitutable.class.getName())) {
            name = data.getClassName();
            parsables.add((Object)name);
            parsables.add((Object)(name + "$class"));
            substitutables.add((Object)name);
            substitutables.add((Object)(name + "$class"));
        }
        log.debug("Found " + implementables.size() / 2 + " @Implementable; " + strippables.size() / 2 + " @Strippable; " + substitutables.size() / 2 + " @Substitutable");
    }

    static /* synthetic */ String[] access$000() {
        return emptyList;
    }

    static {
        implementableDesc = Type.getDescriptor(Implementable.class);
        strippableDesc = Type.getDescriptor(Strippable.class);
        substitutableDesc = Type.getDescriptor(Substitutable.class);
        parsables = new THashSet(30);
        implementables = new THashSet(10);
        strippables = new THashSet(10);
        substitutables = new THashSet(10);
        workingPath = new ArrayList();
        emptyList = new String[0];
    }

    static class AnnotationInfo {
        public String side = "NONE";
        public String[] values = ASMCore.access$000();
        public String method = "!unmatchable!";

        AnnotationInfo() {
        }
    }
}

