/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.asm.LoadingPlugin;
import cofh.core.command.CommandClearBlock;
import cofh.core.command.CommandCountBlock;
import cofh.core.command.CommandEnchant;
import cofh.core.command.CommandFriend;
import cofh.core.command.CommandHand;
import cofh.core.command.CommandHelp;
import cofh.core.command.CommandKillAll;
import cofh.core.command.CommandReloadWorldgen;
import cofh.core.command.CommandReplaceBlock;
import cofh.core.command.CommandSyntax;
import cofh.core.command.CommandTPS;
import cofh.core.command.CommandTPX;
import cofh.core.command.CommandUnloadChunk;
import cofh.core.command.CommandVersion;
import cofh.core.command.ISubCommand;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

public class CommandHandler
extends CommandBase {
    public static final String COMMAND_DISALLOWED = "\u00a7cYou are not allowed to use this command.";
    public static CommandHandler instance = new CommandHandler();
    private static TMap<String, ISubCommand> commands = new THashMap();
    private static DummyCommand dummy;

    public static void initCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)instance);
    }

    public static boolean registerSubCommand(ISubCommand subCommand) {
        if (!commands.containsKey((Object)subCommand.getCommandName())) {
            commands.put((Object)subCommand.getCommandName(), (Object)subCommand);
            return true;
        }
        return false;
    }

    public static Set<String> getCommandList() {
        return commands.keySet();
    }

    public static int getCommandPermission(String command) {
        return CommandHandler.getCommandExists(command) ? ((ISubCommand)commands.get((Object)command)).getPermissionLevel() : Integer.MAX_VALUE;
    }

    public static boolean getCommandExists(String command) {
        return commands.containsKey((Object)command);
    }

    public static boolean canUseCommand(ICommandSender sender, int permission, String name) {
        if (CommandHandler.getCommandExists(name)) {
            return sender.func_70003_b(permission, "cofh " + name) || sender instanceof EntityPlayerMP && permission <= 0;
        }
        return false;
    }

    public int func_82362_a() {
        return -1;
    }

    public static void logAdminCommand(ICommandSender sender, ISubCommand command, String info, Object ... data) {
        dummy.setFromCommand(command);
        int e = data.length;
        for (int i = 0; i < e; ++i) {
            float f;
            Number d;
            int a;
            Object entry = data[i];
            if (!(entry instanceof Number) || (float)(a = (d = (Number)entry).intValue()) == (f = d.floatValue())) continue;
            data[i] = String.format("%.2f", Float.valueOf(f));
        }
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)dummy, (String)info, (Object[])data);
    }

    public String func_71517_b() {
        return "cofh";
    }

    public List<String> func_71514_a() {
        return new ArrayList<String>();
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " help";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer minecraftServer, ICommandSender sender, String[] arguments) throws CommandException {
        ISubCommand command;
        if (arguments.length < 1) {
            arguments = new String[]{"help"};
        }
        if ((command = (ISubCommand)commands.get((Object)arguments[0])) != null) {
            if (CommandHandler.canUseCommand(sender, command.getPermissionLevel(), command.getCommandName())) {
                command.handleCommand(minecraftServer, sender, arguments);
                return;
            }
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        throw new CommandNotFoundException("chat.cofh.command.notFound", new Object[0]);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandHandler.func_175762_a((String[])args, (Collection)commands.keySet());
        }
        if (commands.containsKey((Object)args[0])) {
            return ((ISubCommand)commands.get((Object)args[0])).addTabCompletionOptions(server, sender, args);
        }
        return null;
    }

    static {
        CommandHandler.registerSubCommand(CommandHelp.instance);
        CommandHandler.registerSubCommand(CommandSyntax.instance);
        CommandHandler.registerSubCommand(CommandVersion.instance);
        CommandHandler.registerSubCommand(CommandKillAll.instance);
        CommandHandler.registerSubCommand(CommandTPS.instance);
        CommandHandler.registerSubCommand(CommandTPX.instance);
        CommandHandler.registerSubCommand(CommandEnchant.instance);
        CommandHandler.registerSubCommand(CommandClearBlock.instance);
        CommandHandler.registerSubCommand(CommandReplaceBlock.instance);
        CommandHandler.registerSubCommand(CommandUnloadChunk.instance);
        CommandHandler.registerSubCommand(CommandReloadWorldgen.instance);
        CommandHandler.registerSubCommand(CommandCountBlock.instance);
        CommandHandler.registerSubCommand(CommandHand.instance);
        CommandHandler.registerSubCommand(CommandFriend.instance);
        if (!LoadingPlugin.obfuscated) {
            // empty if block
        }
        dummy = new DummyCommand();
    }

    private static class DummyCommand
    extends CommandBase {
        private int perm = 4;
        private String name = "";

        private DummyCommand() {
        }

        public void setFromCommand(ISubCommand command) {
            this.name = command.getCommandName();
            this.perm = command.getPermissionLevel();
        }

        public String func_71517_b() {
            return "cofh " + this.name;
        }

        public int func_82362_a() {
            return this.perm;
        }

        public String func_71518_a(ICommandSender p_71518_1_) {
            return "";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        }
    }
}

