/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.IFOVUpdateItem;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBowCore
extends ItemBow
implements IEnchantableItem,
IFOVUpdateItem {
    protected String repairIngot = "";
    protected Item.ToolMaterial toolMaterial;
    protected float arrowDamageMultiplier = 0.0f;
    protected float arrowSpeedMultiplier = 0.0f;
    protected float zoomMultiplier = 0.15f;
    protected boolean showInCreative = true;

    public ItemBowCore(Item.ToolMaterial toolMaterial) {
        this.toolMaterial = toolMaterial;
        this.func_77625_d(1);
        this.func_77656_e(toolMaterial.func_77997_a() + 325);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() instanceof ItemBowCore ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ItemBowCore setRepairIngot(String repairIngot) {
        this.repairIngot = repairIngot;
        return this;
    }

    public ItemBowCore setArrowDamage(float multiplier) {
        this.arrowDamageMultiplier = multiplier;
        return this;
    }

    public ItemBowCore setArrowSpeed(float multiplier) {
        this.arrowSpeedMultiplier = multiplier;
        return this;
    }

    public ItemBowCore setZoomMultiplier(float multiplier) {
        this.zoomMultiplier = multiplier;
        return this;
    }

    public ItemBowCore setShowInCreative(boolean showInCreative) {
        this.showInCreative = showInCreative;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        if (this.showInCreative) {
            list.add(new ItemStack(item, 1, 0));
        }
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return ItemHelper.isOreNameEqual(stack, this.repairIngot);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return this.toolMaterial.func_77995_e();
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        boolean flag = this.func_185060_a(player) != null;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemStack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !flag) {
            return !flag ? new ActionResult(EnumActionResult.FAIL, (Object)itemStack) : new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase livingBase, int timeLeft) {
        if (livingBase instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)livingBase;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack arrowStack = this.func_185060_a(entityplayer);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)livingBase), (int)i, (arrowStack != null || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (arrowStack != null || flag) {
                if (arrowStack == null) {
                    arrowStack = new ItemStack(Items.field_151032_g);
                }
                float f = ItemBowCore.func_185059_b((int)i);
                float speedMod = 1.0f + this.arrowSpeedMultiplier;
                if ((double)f >= 0.1) {
                    if (!world.field_72995_K) {
                        int enchantMultishot = MathHelper.clamp(EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.multishot, (ItemStack)stack), 0, 10);
                        int punchLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
                        int powerLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                        boolean flame = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0;
                        this.onBowFired(entityplayer, stack);
                        for (int shot = 0; shot <= enchantMultishot; ++shot) {
                            ItemArrow itemarrow = (ItemArrow)(arrowStack.func_77973_b() instanceof ItemArrow ? arrowStack.func_77973_b() : Items.field_151032_g);
                            EntityArrow arrow = itemarrow.func_185052_a(world, arrowStack, (EntityLivingBase)entityplayer);
                            arrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f * speedMod, 1.0f);
                            arrow.func_70239_b(arrow.func_70242_d() * (double)(1.0f + this.arrowDamageMultiplier));
                            if (f >= 1.0f) {
                                arrow.func_70243_d(true);
                            }
                            if (powerLvl > 0) {
                                arrow.func_70239_b(arrow.func_70242_d() + (double)powerLvl * 0.5 + 0.5);
                            }
                            if (punchLvl > 0) {
                                arrow.func_70240_a(punchLvl);
                            }
                            if (flame) {
                                arrow.func_70015_d(100);
                            }
                            if (flag) {
                                arrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                            }
                            world.func_72838_d((Entity)arrow);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                    }
                    world.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag) {
                        --arrowStack.field_77994_a;
                        if (arrowStack.field_77994_a == 0) {
                            entityplayer.field_71071_by.func_184437_d(arrowStack);
                        }
                    }
                    entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
                }
            }
        }
    }

    public void onBowFired(EntityPlayer player, ItemStack stack) {
    }

    @Override
    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.multishot;
    }

    @Override
    public float getFOVMod(ItemStack stack, EntityPlayer player) {
        float progress = MathHelper.clamp((float)(stack.func_77988_m() - player.func_184605_cv()) / 20.0f, 0.0f, 1.0f);
        return progress * progress * this.zoomMultiplier;
    }
}

