/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.core.entity.EntityFishHookCore;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFishingRodCore
extends ItemFishingRod {
    protected String repairIngot = "";
    protected Item.ToolMaterial toolMaterial;
    protected int luckModifier = 0;
    protected int speedModifier = 0;
    protected boolean showInCreative = true;

    public ItemFishingRodCore(Item.ToolMaterial toolMaterial) {
        this.toolMaterial = toolMaterial;
        this.func_77625_d(1);
        this.func_77656_e(toolMaterial.func_77997_a() + 5);
        this.func_185043_a(new ResourceLocation("cast"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn == null ? 0.0f : (entityIn.func_184614_ca() == stack && entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).field_71104_cf != null ? 1.0f : 0.0f);
            }
        });
    }

    public ItemFishingRodCore setRepairIngot(String repairIngot) {
        this.repairIngot = repairIngot;
        return this;
    }

    public ItemFishingRodCore setShowInCreative(boolean showInCreative) {
        this.showInCreative = showInCreative;
        return this;
    }

    public ItemFishingRodCore setLuckModifier(int luckModifier) {
        this.luckModifier = luckModifier;
        return this;
    }

    public ItemFishingRodCore setSpeedModifier(int speedModifier) {
        this.speedModifier = speedModifier;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        if (this.showInCreative) {
            list.add(new ItemStack(item, 1, 0));
        }
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return ItemHelper.isOreNameEqual(stack, this.repairIngot);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return this.toolMaterial.func_77995_e();
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.field_71104_cf != null) {
            int i = player.field_71104_cf.func_146034_e();
            stack.func_77972_a(i, (EntityLivingBase)player);
            player.func_184609_a(hand);
        } else {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (ServerHelper.isServerWorld(world)) {
                world.func_72838_d((Entity)new EntityFishHookCore(world, player, this.luckModifier, this.speedModifier));
            }
            player.func_184609_a(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

