/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.proxy;

import cofh.core.init.CoreProps;
import cofh.core.item.tool.ItemShieldCore;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.key.KeyHandlerCore;
import cofh.lib.util.helpers.MathHelper;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Proxy {
    public void preInit(FMLPreInitializationEvent event) {
    }

    public void initialize(FMLInitializationEvent event) {
        this.registerKeyBinds();
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void registerKeyBinds() {
        KeyHandlerCore.addServerKeyBind(KeyBindingItemMultiMode.instance);
    }

    public int getKeyBind(String key) {
        return 0;
    }

    public void addIndexedChatMessage(ITextComponent chat, int index) {
    }

    @SubscribeEvent
    public void handleLivingAttackEvent(LivingAttackEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).func_184607_cu() != null) {
            ItemStack stack = player.func_184607_cu();
            float damage = event.getAmount();
            if (damage >= 3.0f && stack != null && stack.func_77973_b() instanceof ItemShieldCore) {
                ((ItemShieldCore)stack.func_77973_b()).damageShield(stack, 1 + MathHelper.floor(damage), player, event.getSource().func_76346_g());
                if (stack.field_77994_a <= 0) {
                    EnumHand enumhand = player.func_184600_cs();
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)player.field_184627_bm, (EnumHand)enumhand);
                    if (enumhand == EnumHand.MAIN_HAND) {
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
                    } else {
                        player.func_184201_a(EntityEquipmentSlot.OFFHAND, null);
                    }
                    player.field_184627_bm = null;
                    player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleLivingDeathEvent(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!CoreProps.enableLivingEntityDeathMessages || entity.field_70170_p.field_72995_K || !(entity instanceof EntityLiving) || !event.getEntityLiving().func_145818_k_()) {
            return;
        }
        entity.field_70170_p.func_73046_m().func_184103_al().func_148539_a(event.getEntityLiving().func_110142_aN().func_151521_b());
    }

    @SubscribeEvent
    public void handleLivingDropsEvent(LivingDropsEvent event) {
    }

    @SubscribeEvent
    public void handleSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        if (CoreProps.treeGrowthChance < 100 && event.getWorld().field_73012_v.nextInt(100) >= CoreProps.treeGrowthChance) {
            event.setResult(Event.Result.DENY);
        }
    }

    public boolean isOp(String playerName) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        playerName = playerName.trim();
        for (String a : server.func_184103_al().func_152606_n()) {
            if (!playerName.equalsIgnoreCase(a)) continue;
            return true;
        }
        return false;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isServer() {
        return true;
    }

    public World getClientWorld() {
        return null;
    }

    public IThreadListener getClientListener() {
        return null;
    }

    public IThreadListener getServerListener() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public EntityPlayer findPlayer(String player) {
        return null;
    }

    public EntityPlayer getClientPlayer() {
        return null;
    }

    public List<EntityPlayer> getPlayerList() {
        LinkedList<EntityPlayer> result = new LinkedList<EntityPlayer>();
        for (int i = 0; i < FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length; ++i) {
            if (FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[i] == null) continue;
            result.addAll(FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[i].field_73010_i);
        }
        return result;
    }

    public void updateFriendListGui() {
    }

    public float getSoundVolume(int category) {
        return 0.0f;
    }
}

