/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.crafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;

public class RecipeShapelessOreFluid
extends ShapelessOreRecipe {
    public RecipeShapelessOreFluid(Block result, Object ... recipe) {
        super(result, RecipeShapelessOreFluid.replaceFluidWithUniversalBucket(recipe));
    }

    public RecipeShapelessOreFluid(Item result, Object ... recipe) {
        super(result, RecipeShapelessOreFluid.replaceFluidWithUniversalBucket(recipe));
    }

    public RecipeShapelessOreFluid(ItemStack result, Object ... recipe) {
        super(result, RecipeShapelessOreFluid.replaceFluidWithUniversalBucket(recipe));
    }

    public static Object[] replaceFluidWithUniversalBucket(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            Object obj = array[i];
            if (obj instanceof Fluid) {
                ItemStack filledBucket = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)((Fluid)obj));
                array[i] = filledBucket;
                continue;
            }
            if (!(obj instanceof FluidStack)) continue;
            ItemStack bucket = ForgeModContainer.getInstance().universalBucket.getEmpty().func_77946_l();
            IFluidHandler handler = (IFluidHandler)Validate.notNull((Object)FluidUtil.getFluidHandler((ItemStack)bucket));
            handler.fill((FluidStack)obj, true);
            array[i] = bucket;
        }
        return array;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        ItemStack[] ret = new ItemStack[inv.func_70302_i_()];
        for (int i = 0; i < ret.length; ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)stackInSlot);
            if (fluidHandler == null) {
                ret[i] = ForgeHooks.getContainerItem((ItemStack)stackInSlot);
                continue;
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.field_77994_a = 1;
            ((IFluidHandler)Validate.notNull((Object)FluidUtil.getFluidHandler((ItemStack)copy))).drain(1000, true);
            ret[i] = copy.func_77973_b() != null && copy.field_77994_a > 0 && (!copy.func_77984_f() || copy.func_77960_j() <= copy.func_77958_k()) ? copy : null;
        }
        return ret;
    }

    public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
        ArrayList required = new ArrayList(this.input);
        for (int i = 0; i < inventoryCrafting.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventoryCrafting.func_70301_a(i);
            if (stackInSlot == null) continue;
            boolean inRecipe = false;
            for (Object aRequired : required) {
                boolean match;
                block6: {
                    block4: {
                        ItemStack requiredStack;
                        block5: {
                            match = false;
                            if (!(aRequired instanceof ItemStack)) break block4;
                            requiredStack = (ItemStack)aRequired;
                            if (requiredStack.func_77973_b() != ForgeModContainer.getInstance().universalBucket) break block5;
                            FluidStack fluidStack = (FluidStack)Validate.notNull((Object)FluidUtil.getFluidContained((ItemStack)requiredStack));
                            IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)stackInSlot);
                            if (fluidHandler == null || !fluidStack.isFluidStackIdentical(fluidHandler.drain(1000, false))) break block6;
                            match = true;
                            break block6;
                        }
                        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)stackInSlot);
                        if (fluidHandler != null) break block6;
                        match = OreDictionary.itemMatches((ItemStack)requiredStack, (ItemStack)stackInSlot, (boolean)false);
                        break block6;
                    }
                    if (aRequired instanceof List) {
                        for (ItemStack stack : (List)aRequired) {
                            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)stackInSlot, (boolean)false)) continue;
                            match = true;
                            break;
                        }
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(aRequired);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }
}

