/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.api.core.IAugmentable;
import cofh.api.item.IAugmentItem;
import cofh.api.item.IUpgradeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AugmentHelper {
    private AugmentHelper() {
    }

    public static NBTTagCompound setItemStackTagAugments(NBTTagCompound tag, IAugmentable tile) {
        if (tile == null) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        AugmentHelper.writeAugmentsToNBT(tag, tile.getAugmentSlots());
        return tag;
    }

    public static void writeAugmentsToNBT(NBTTagCompound nbt, ItemStack[] augments) {
        if (augments.length <= 0) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < augments.length; ++i) {
            if (augments[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            augments[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Augments", (NBTBase)list);
    }

    public static boolean isAugmentItem(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IAugmentItem;
    }

    public static IAugmentItem.AugmentType getAugmentType(ItemStack stack) {
        return ((IAugmentItem)stack.func_77973_b()).getAugmentType(stack);
    }

    public static String getAugmentIdentifier(ItemStack stack) {
        return ((IAugmentItem)stack.func_77973_b()).getAugmentIdentifier(stack);
    }

    public static boolean isUpgradeItem(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IUpgradeItem;
    }
}

